/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.internal.console.ansi.AnsiMessages;

public class AnsiConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor fAnsiEnabled;
    private BooleanFieldEditor fWindowsMapping;
    private BooleanFieldEditor fShowEscapes;
    private BooleanFieldEditor fKeepStderrColor;
    private BooleanFieldEditor fRtfInClipboard;
    private ComboFieldEditor fColorPalette;

    public AnsiConsolePreferencePage() {
        super(1);
        this.setPreferenceStore(ConsolePlugin.getDefault().getPreferenceStore());
        this.setDescription(AnsiMessages.PreferencePage_Title);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IConsoleHelpContextIds.CONSOLE_ANSI_PREFERENCE_PAGE);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.fAnsiEnabled = new BooleanFieldEditor("ANSI_support_enabled", AnsiMessages.PreferencePage_PluginEnabled, parent);
        this.addField((FieldEditor)this.fAnsiEnabled);
        this.fWindowsMapping = new BooleanFieldEditor("ANSI_support_use_windows_color_mapping", AnsiMessages.PreferencePage_Option_WindowsMapping, parent);
        this.addField((FieldEditor)this.fWindowsMapping);
        this.fShowEscapes = new BooleanFieldEditor("ANSI_support_show_escapes", AnsiMessages.PreferencePage_Option_ShowEscapes, parent);
        this.addField((FieldEditor)this.fShowEscapes);
        this.fKeepStderrColor = new BooleanFieldEditor("ANSI_support_keep_stderr_color", AnsiMessages.PreferencePage_Option_HonorStderr, parent);
        this.addField((FieldEditor)this.fKeepStderrColor);
        this.fRtfInClipboard = new BooleanFieldEditor("ANSI_support_put_rtf_to_clipboard", AnsiMessages.PreferencePage_Option_RtfInClipboard, parent);
        this.addField((FieldEditor)this.fRtfInClipboard);
        this.fColorPalette = new ComboFieldEditor("ANSI_support_color_palette", AnsiMessages.PreferencePage_Option_ColorPaletteSectionTitle, (String[][])new String[][]{{AnsiMessages.PreferencePage_Option_ColorPaletteVGA, "paletteVGA"}, {AnsiMessages.PreferencePage_Option_ColorPaletteWinXP, "paletteXP"}, {AnsiMessages.PreferencePage_Option_ColorPaletteWin10, "paletteWin10"}, {AnsiMessages.PreferencePage_Option_ColorPaletteMacOS, "paletteMac"}, {AnsiMessages.PreferencePage_Option_ColorPalettePutty, "palettePuTTY"}, {AnsiMessages.PreferencePage_Option_ColorPaletteXterm, "paletteXTerm"}, {AnsiMessages.PreferencePage_Option_ColorPaletteMirc, "paletteMirc"}, {AnsiMessages.PreferencePage_Option_ColorPaletteUbuntu, "paletteUbuntu"}}, parent);
        this.addField((FieldEditor)this.fColorPalette);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.enableDisableAll();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand("AnsiConsole.command.enable_disable", new Event());
        }
        catch (Exception exception) {
            System.out.println("AnsiConsole: Command 'AnsiConsole.command.enable_disable' not found");
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        if (source != null && source.equals(this.fAnsiEnabled)) {
            this.enableDisableAll();
        }
    }

    private void enableDisableAll() {
        Composite parent = this.getFieldEditorParent();
        boolean enable = this.fAnsiEnabled.getBooleanValue();
        this.fWindowsMapping.setEnabled(enable, parent);
        this.fShowEscapes.setEnabled(enable, parent);
        this.fKeepStderrColor.setEnabled(enable, parent);
        this.fRtfInClipboard.setEnabled(enable, parent);
        this.fColorPalette.setEnabled(enable, parent);
    }
}

