/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.core.api.IDescriptionPreprocessor;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.SiriusPropertiesCorePlugin;

public class DefaultDescriptionPreprocessor<SIRIUS extends EObject>
implements IDescriptionPreprocessor {
    protected static final String EXTENDS_FEATURE_NAME = "extends";
    private static final String VALIDATION_RULES_FEATURE_NAME = "validationRules";
    protected Class<SIRIUS> descriptionClass;

    public DefaultDescriptionPreprocessor(Class<SIRIUS> descriptionClass) {
        this.descriptionClass = descriptionClass;
    }

    @Override
    public EObject convert(EObject originalDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        EObject createdDescription;
        EObject processedDescription = null;
        if (this.descriptionClass.isAssignableFrom(originalDescription.getClass()) && this.descriptionClass.isAssignableFrom((createdDescription = originalDescription.eClass().getEPackage().getEFactoryInstance().create(originalDescription.eClass())).getClass())) {
            processedDescription = (EObject)this.descriptionClass.cast(createdDescription);
            cache.put(originalDescription, processedDescription);
            EObject siriusOriginalDescription = (EObject)this.descriptionClass.cast(originalDescription);
            this.processDescriptionOverrides(processedDescription, siriusOriginalDescription, cache, interpreter, variableManager, overridesProvider);
            this.processDescriptionPropertiesRecursively(processedDescription, siriusOriginalDescription, cache, interpreter, variableManager, overridesProvider);
        }
        return processedDescription;
    }

    private void processDescriptionOverrides(SIRIUS processedDescription, SIRIUS originalDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        Optional<OverridesProvider> overridesProviderOpt = Optional.ofNullable(overridesProvider);
        overridesProviderOpt.ifPresent(provider -> provider.getOverrideDescriptions((EObject)originalDescription).stream().findFirst().ifPresent(overrideDescription -> {
            Optional<IDescriptionPreprocessor> optionalOverrideDescriptionPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)overrideDescription);
            optionalOverrideDescriptionPreprocessor.ifPresent(overrideDescriptionPreprocessor -> {
                IDescriptionPreprocessor descriptionPreprocessor = (IDescriptionPreprocessor)optionalOverrideDescriptionPreprocessor.get();
                if (descriptionPreprocessor instanceof DefaultDescriptionPreprocessor) {
                    DefaultDescriptionPreprocessor preprocessor = (DefaultDescriptionPreprocessor)descriptionPreprocessor;
                    EObject processedOverrideDescription = preprocessor.convert((EObject)overrideDescription, cache, interpreter, variableManager, overridesProvider);
                    for (EStructuralFeature eStructuralFeature : processedOverrideDescription.eClass().getEAllStructuralFeatures()) {
                        if (!processedOverrideDescription.eIsSet(eStructuralFeature) || processedDescription.eClass().getEStructuralFeature(eStructuralFeature.getName()) == null) continue;
                        processedDescription.eSet(eStructuralFeature, processedOverrideDescription.eGet(eStructuralFeature));
                    }
                }
            });
        }));
    }

    protected void processDescriptionPropertiesRecursively(SIRIUS processedDescription, SIRIUS originalDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        Optional<Object> currentDescription = Optional.of(originalDescription);
        while (currentDescription.isPresent()) {
            for (EStructuralFeature feature : ((EObject)currentDescription.get()).eClass().getEAllStructuralFeatures()) {
                this.processDescriptionFeature(feature, processedDescription, (EObject)currentDescription.get(), cache, interpreter, variableManager, overridesProvider);
            }
            currentDescription = this.getParentOf((EObject)currentDescription.get());
        }
    }

    protected Optional<SIRIUS> getParentOf(SIRIUS description) {
        Optional<Object> nextParent = Optional.empty();
        EStructuralFeature extensionFeature = description.eClass().getEStructuralFeature(EXTENDS_FEATURE_NAME);
        if (extensionFeature instanceof EReference) {
            EReference extendsEReference = (EReference)extensionFeature;
            Optional<Object> currentExtends = Optional.ofNullable(description.eGet((EStructuralFeature)extendsEReference));
            nextParent = currentExtends.map(ref -> (EObject)this.descriptionClass.cast(ref));
        }
        return nextParent;
    }

    protected void processDescriptionFeature(EStructuralFeature feature, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (feature instanceof EAttribute) {
            if (!feature.isMany()) {
                this.processMonoValuedEAttribute((EAttribute)feature, processedDescription, currentDescription, cache);
            } else {
                this.processMultiValuedEAttribute((EAttribute)feature, processedDescription, currentDescription, cache);
            }
        } else if (feature instanceof EReference) {
            if (!feature.isMany()) {
                this.processMonoValuedEReference((EReference)feature, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
            } else {
                this.processMultiValuedEReference((EReference)feature, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
            }
        }
    }

    protected void processMonoValuedEAttribute(EAttribute eAttribute, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache) {
        if (!processedDescription.eIsSet((EStructuralFeature)eAttribute)) {
            processedDescription.eSet((EStructuralFeature)eAttribute, currentDescription.eGet((EStructuralFeature)eAttribute));
        }
    }

    protected void processMultiValuedEAttribute(EAttribute eAttribute, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache) {
        Object processedValue = processedDescription.eGet((EStructuralFeature)eAttribute);
        Object currentValue = currentDescription.eGet((EStructuralFeature)eAttribute);
        if (currentValue instanceof Iterable && processedValue instanceof Iterable) {
            ArrayList newValue = new ArrayList();
            Iterable currentIterable = (Iterable)currentValue;
            Iterable processedIterable = (Iterable)processedValue;
            currentIterable.forEach(newValue::add);
            processedIterable.forEach(newValue::add);
            processedDescription.eSet((EStructuralFeature)eAttribute, newValue);
        }
    }

    protected void processMonoValuedEReference(EReference eReference, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        Object currentValue;
        if (!processedDescription.eIsSet((EStructuralFeature)eReference) && (currentValue = currentDescription.eGet((EStructuralFeature)eReference)) instanceof EObject) {
            Optional<IDescriptionPreprocessor> optionalPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)currentValue);
            optionalPreprocessor.ifPresent(preprocessor -> {
                EObject processedValue = preprocessor.convert((EObject)currentValue, cache, interpreter, variableManager, overridesProvider);
                processedDescription.eSet((EStructuralFeature)eReference, (Object)processedValue);
            });
        }
    }

    protected void processMultiValuedEReference(EReference eReference, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        Object processedValue = processedDescription.eGet((EStructuralFeature)eReference);
        Object currentValue = currentDescription.eGet((EStructuralFeature)eReference);
        if (currentValue instanceof Iterable && processedValue instanceof Iterable) {
            ArrayList newValue = new ArrayList();
            Iterable currentIterable = (Iterable)currentValue;
            Iterable processedIterable = (Iterable)processedValue;
            StreamSupport.stream(currentIterable.spliterator(), false).filter(EObject.class::isInstance).map(EObject.class::cast).forEach(siriusDescription -> {
                if (!this.isFiltered((EStructuralFeature)eReference, (EObject)processedDescription, (EObject)siriusDescription, cache, interpreter, variableManager, overridesProvider)) {
                    SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)siriusDescription).map(preprocessor -> preprocessor.convert((EObject)siriusDescription, cache, interpreter, variableManager, overridesProvider)).map(newValue::add);
                }
            });
            processedIterable.forEach(newValue::add);
            processedDescription.eSet((EStructuralFeature)eReference, newValue);
        }
    }

    @Override
    public boolean canHandle(EObject description) {
        return true;
    }

    protected boolean isFiltered(EStructuralFeature eStructuralFeature, EObject processedDescription, EObject currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        List overrideDescriptions = cache.getInput(processedDescription).filter(EObject.class::isInstance).map(EObject.class::cast).map(overridesProvider::getOverrideDescriptions).orElseGet(ArrayList::new);
        boolean isFiltered = overrideDescriptions.stream().anyMatch(overrideDescription -> this.isFiltered(eStructuralFeature, (EObject)overrideDescription, currentDescription, interpreter, variableManager, "Overridden"));
        if (!isFiltered) {
            isFiltered = this.isFiltered(eStructuralFeature, processedDescription, currentDescription, interpreter, variableManager, "Extended");
        }
        return isFiltered;
    }

    private boolean isFiltered(EStructuralFeature eStructuralFeature, EObject processedDescription, EObject currentDescription, IInterpreter interpreter, IVariableManager variableManager, String featureKind) {
        String filterFeatureName = this.getFilterFeatureName(eStructuralFeature);
        String parentTypeName = this.getTypeName(processedDescription);
        String filterName = this.getFilterName(filterFeatureName, parentTypeName, featureKind);
        Optional<EStructuralFeature> optionalFilterFeature = Optional.ofNullable(processedDescription.eClass().getEStructuralFeature(filterName));
        Optional<Boolean> optionalFilterExpression = optionalFilterFeature.flatMap(filterFeature -> this.getFilterExpression(processedDescription, (EStructuralFeature)filterFeature));
        return optionalFilterExpression.map(filteringExpression -> {
            Map<String, Object> variables = this.computeFilterVariables(variableManager, currentDescription, filterFeatureName);
            return this.evaluateFilter((String)filteringExpression, interpreter, variables);
        }).orElse(false);
    }

    private String getFilterFeatureName(EStructuralFeature eStructuralFeature) {
        String eStructuralFeatureName = eStructuralFeature.getName();
        if (PropertiesPackage.Literals.GROUP_VALIDATION_SET_DESCRIPTION__SEMANTIC_VALIDATION_RULES.getName().equals(eStructuralFeatureName) || PropertiesPackage.Literals.GROUP_VALIDATION_SET_DESCRIPTION__PROPERTY_VALIDATION_RULES.getName().equals(eStructuralFeatureName)) {
            eStructuralFeatureName = VALIDATION_RULES_FEATURE_NAME;
        }
        return eStructuralFeatureName;
    }

    private String getTypeName(EObject processedDescription) {
        return processedDescription.eClass().getName().replace("Description", "").replace("Override", "");
    }

    private String getFilterName(String eStructuralFeatureName, String parentTypeName, String featureKind) {
        return "filter" + eStructuralFeatureName.substring(0, 1).toUpperCase() + eStructuralFeatureName.substring(1) + "From" + featureKind + parentTypeName + "Expression";
    }

    private Optional<String> getFilterExpression(EObject processedDescription, EStructuralFeature eStructuralFeature) {
        return Optional.ofNullable(processedDescription.eGet(eStructuralFeature)).filter(String.class::isInstance).map(String.class::cast);
    }

    private Map<String, Object> computeFilterVariables(IVariableManager variableManager, EObject currentDescription, String eStructuralFeatureName) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(variableManager.getVariables());
        String variableName = this.getVariableName(eStructuralFeatureName) + "Description";
        variables.put(variableName, currentDescription);
        return variables;
    }

    private String getVariableName(String eStructuralFeatureName) {
        return eStructuralFeatureName.substring(0, eStructuralFeatureName.length() - 1);
    }

    private boolean evaluateFilter(String filteringExpression, IInterpreter interpreter, Map<String, Object> variables) {
        IEvaluationResult evaluationResult = interpreter.evaluateExpression(variables, filteringExpression);
        return Optional.ofNullable(evaluationResult).filter(IEvaluationResult::success).map(IEvaluationResult::getValue).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
    }
}

