/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTagElement;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ScannerMessages;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.text.edits.TextEdit;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApiDescriptionProcessor {
    private ApiDescriptionProcessor() {
    }

    public static String serializeComponentXml(File location) {
        if (location.exists()) {
            ZipFile jarFile = null;
            InputStream stream = null;
            try {
                String extension = IPath.fromOSString((String)location.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && location.isFile()) {
                    jarFile = new ZipFile(location, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("component.xml");
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else if (location.isDirectory()) {
                    File file = new File(location, "component.xml");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                } else if (location.isFile() && location.getName().equals("component.xml")) {
                    stream = new FileInputStream(location);
                }
                if (stream != null) {
                    String string = new String(Util.getInputStreamAsCharArray(stream, StandardCharsets.UTF_8));
                    return string;
                }
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    public static void collectTagUpdates(IJavaProject project, File componentxml, Map<IFile, Set<TextEdit>> collector) throws CoreException, IOException {
        ApiDescription description = new ApiDescription(null);
        ApiDescriptionProcessor.annotateApiSettings(project, description, ApiDescriptionProcessor.serializeComponentXml(componentxml));
        DescriptionVisitor visitor = new DescriptionVisitor(project, description, collector);
        description.accept(visitor, null);
        IStatus status = visitor.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    static void processTagUpdates(IType type, IReferenceTypeDescriptor desc, IApiDescription description, List<IElementDescriptor> members, Map<IFile, Set<TextEdit>> collector) throws CoreException, BadLocationException {
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        ICompilationUnit cunit = type.getCompilationUnit();
        if (cunit != null) {
            parser.setSource(cunit);
            Map options = cunit.getJavaProject().getOptions(true);
            options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            parser.setCompilerOptions(options);
            CompilationUnit cast = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            cast.recordModifications();
            ASTRewrite rewrite = ASTRewrite.create((AST)cast.getAST());
            ASTTagVisitor visitor = new ASTTagVisitor(members, description, rewrite);
            cast.accept((ASTVisitor)visitor);
            ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
            IPath path = cast.getJavaElement().getPath();
            try {
                bm.connect(path, LocationKind.IFILE, null);
                ITextFileBuffer tfb = bm.getTextFileBuffer(path, LocationKind.IFILE);
                IDocument document = tfb.getDocument();
                TextEdit edit = rewrite.rewriteAST(document, null);
                if (edit.getChildrenSize() > 0 || edit.getLength() != 0) {
                    IFile file = (IFile)cunit.getUnderlyingResource();
                    Set<TextEdit> edits = collector.get(file);
                    if (edits == null) {
                        edits = new HashSet<TextEdit>(3);
                        collector.put(file, edits);
                    }
                    edits.add(edit);
                }
            }
            finally {
                bm.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        IStatus status = Status.error((String)message, (Throwable)exception);
        throw new CoreException(status);
    }

    public static void annotateApiSettings(IJavaProject project, IApiDescription settings, String xml) throws CoreException {
        Element root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            ApiDescriptionProcessor.abort("Failed to parse API description xml file", ce);
        }
        if (!root.getNodeName().equals("component")) {
            ApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_0, null);
        }
        String version = root.getAttribute("version");
        ApiDescription desc = (ApiDescription)settings;
        desc.setEmbeddedVersion(version);
        boolean earlierversion = desc.compareEmbeddedVersionTo("1.2") == 1;
        NodeList packages = root.getElementsByTagName("package");
        NodeList types = null;
        IPackageDescriptor packdesc = null;
        Element type = null;
        int i = 0;
        while (i < packages.getLength()) {
            Element pkg = (Element)packages.item(i);
            String pkgName = pkg.getAttribute("name");
            packdesc = Factory.packageDescriptor(pkgName);
            types = pkg.getElementsByTagName("type");
            int j = 0;
            while (j < types.getLength()) {
                type = (Element)types.item(j);
                String name = type.getAttribute("name");
                if (name.length() == 0) {
                    ApiDescriptionProcessor.abort("Missing type name", null);
                }
                IReferenceTypeDescriptor typedesc = packdesc.getType(name);
                ApiDescriptionProcessor.annotateDescriptor(project, settings, typedesc, type, earlierversion);
                ApiDescriptionProcessor.annotateMethodSettings(project, settings, typedesc, type, earlierversion);
                ApiDescriptionProcessor.annotateFieldSettings(project, settings, typedesc, type, earlierversion);
                ++j;
            }
            ++i;
        }
    }

    private static void annotateDescriptor(IJavaProject project, IApiDescription settings, IElementDescriptor descriptor, Element element, boolean earlierversion) {
        int typeVis = ApiDescriptionProcessor.getVisibility(element);
        if (typeVis != -1) {
            settings.setVisibility(descriptor, typeVis);
        }
        settings.setRestrictions(descriptor, ApiDescriptionProcessor.getRestrictions(project, element, descriptor, earlierversion));
    }

    private static int getRestrictions(IJavaProject project, Element element, IElementDescriptor descriptor, boolean earlierversion) {
        int res = 0;
        if (element.hasAttribute("restrictions")) {
            res = Integer.parseInt(element.getAttribute("restrictions"));
        } else {
            switch (descriptor.getElementType()) {
                case 5: {
                    res = ApiDescriptionProcessor.annotateRestriction(element, "reference", 8, res);
                    break;
                }
                case 6: {
                    IMethodDescriptor method = (IMethodDescriptor)descriptor;
                    res = ApiDescriptionProcessor.annotateRestriction(element, "reference", 8, res);
                    if (method.isConstructor()) break;
                    res = ApiDescriptionProcessor.annotateRestriction(element, "override", 16, res);
                    break;
                }
                case 2: {
                    IReferenceTypeDescriptor rtype = (IReferenceTypeDescriptor)descriptor;
                    res = ApiDescriptionProcessor.annotateRestriction(element, "implement", 1, res);
                    if (earlierversion && RestrictionModifiers.isImplementRestriction(res)) {
                        res |= 2;
                    }
                    if (!RestrictionModifiers.isExtendRestriction(res = ApiDescriptionProcessor.annotateRestriction(element, "extend", 2, res))) {
                        res = ApiDescriptionProcessor.annotateRestriction(element, "subclass", 2, res);
                    }
                    res = ApiDescriptionProcessor.annotateRestriction(element, "instantiate", 4, res);
                    IType type = null;
                    if (project == null) break;
                    try {
                        type = project.findType(rtype.getQualifiedName());
                        IType typeInProject = Util.getTypeInSameJavaProject(type, rtype.getQualifiedName(), project);
                        if (typeInProject != null) {
                            type = typeInProject;
                        }
                    }
                    catch (JavaModelException e) {
                        ApiPlugin.log("Failed to find type for " + rtype.getQualifiedName(), e);
                    }
                    if (type == null) break;
                    try {
                        if (Flags.isInterface((int)type.getFlags())) {
                            res &= 0xFFFFFFFB;
                            break;
                        }
                        res &= 0xFFFFFFFE;
                        if (Flags.isFinal((int)type.getFlags())) {
                            res &= 0xFFFFFFFD;
                        }
                        if (!Flags.isAbstract((int)type.getFlags())) break;
                        res &= 0xFFFFFFFB;
                    }
                    catch (JavaModelException e) {
                        ApiPlugin.log("Failed to read type flags for " + String.valueOf(type), e);
                    }
                    break;
                }
            }
        }
        return res;
    }

    private static int annotateRestriction(Element element, String name, int flag, int res) {
        String value = element.getAttribute(name);
        int lres = res;
        if (value.length() > 0 && !Boolean.parseBoolean(value)) {
            lres = res | flag;
        }
        return lres;
    }

    private static int getVisibility(Element element) {
        String attribute = element.getAttribute("visibility");
        if (attribute != null && attribute.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException numberFormatException) {
            if ("API".equals(attribute)) {
                return 1;
            }
            if ("PRIVATE".equals(attribute)) {
                return 2;
            }
            if ("PRIVATE_PERMISSABLE".equals(attribute)) {
                return 8;
            }
            if ("SPI".equals(attribute)) {
                return 4;
            }
            return -1;
        }
    }

    private static void annotateFieldSettings(IJavaProject project, IApiDescription settings, IReferenceTypeDescriptor typedesc, Element type, boolean earlierversion) throws CoreException {
        NodeList fields = type.getElementsByTagName("field");
        Element field = null;
        IFieldDescriptor fielddesc = null;
        String name = null;
        int i = 0;
        while (i < fields.getLength()) {
            field = (Element)fields.item(i);
            name = field.getAttribute("name");
            if (name == null) {
                ApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_1, null);
            }
            fielddesc = typedesc.getField(name);
            ApiDescriptionProcessor.annotateDescriptor(project, settings, fielddesc, field, earlierversion);
            ++i;
        }
    }

    private static void annotateMethodSettings(IJavaProject project, IApiDescription settings, IReferenceTypeDescriptor typedesc, Element type, boolean earlierversion) throws CoreException {
        NodeList methods = type.getElementsByTagName("method");
        Element method = null;
        IMethodDescriptor methoddesc = null;
        int i = 0;
        while (i < methods.getLength()) {
            String signature;
            method = (Element)methods.item(i);
            String name = method.getAttribute("name");
            if (name == null) {
                ApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_2, null);
            }
            if ((signature = method.getAttribute("signature")) == null) {
                ApiDescriptionProcessor.abort(ScannerMessages.ComponentXMLScanner_3, null);
            }
            signature = signature.replace('.', '/');
            methoddesc = typedesc.getMethod(name, signature);
            ApiDescriptionProcessor.annotateDescriptor(project, settings, methoddesc, method, earlierversion);
            ++i;
        }
    }

    static class ASTTagVisitor
    extends ASTVisitor {
        private List<IElementDescriptor> apis = null;
        private IApiDescription description = null;
        private ASTRewrite rewrite = null;
        private final Stack<Integer> typeStack;

        public ASTTagVisitor(List<IElementDescriptor> apis, IApiDescription description, ASTRewrite rewrite) {
            this.apis = apis;
            this.description = description;
            this.rewrite = rewrite;
            this.typeStack = new Stack();
        }

        public boolean visit(TypeDeclaration node) {
            int type = 1;
            if (node.isInterface()) {
                type = 2;
            }
            this.typeStack.push(type);
            this.updateDocNode(this.findDescriptorByName(node.getName().getFullyQualifiedName(), null), (BodyDeclaration)node, this.getType(), 16);
            return true;
        }

        public void endVisit(TypeDeclaration node) {
            this.typeStack.pop();
        }

        private int getType() {
            return this.typeStack.peek();
        }

        public boolean visit(FieldDeclaration node) {
            List fields = node.fragments();
            VariableDeclarationFragment fragment2 = null;
            for (VariableDeclarationFragment fragment2 : fields) {
                this.updateDocNode(this.findDescriptorByName(fragment2.getName().getFullyQualifiedName(), null), (BodyDeclaration)node, this.getType(), 8);
            }
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            String signature = Signatures.getMethodSignatureFromNode(node, true);
            if (signature != null) {
                this.updateDocNode(this.findDescriptorByName(node.getName().getFullyQualifiedName(), signature), (BodyDeclaration)node, this.getType(), 4);
            }
            return false;
        }

        private void updateDocNode(IElementDescriptor element, BodyDeclaration body, int type, int member) {
            IApiAnnotations api;
            if (element != null && (api = this.description.resolveAnnotations(element)) != null) {
                String[] missingtags;
                boolean newnode;
                Javadoc docnode = body.getJavadoc();
                AST ast = body.getAST();
                boolean bl = newnode = docnode == null;
                if (docnode == null) {
                    docnode = ast.newJavadoc();
                }
                if ((missingtags = this.collectMissingTags(api, docnode.tags(), type, member)).length == 0) {
                    return;
                }
                if (newnode) {
                    this.rewrite.set((ASTNode)body, (StructuralPropertyDescriptor)body.getJavadocProperty(), (Object)docnode, null);
                }
                ListRewrite lrewrite = this.rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
                TagElement newtag = null;
                String[] stringArray = missingtags;
                int n = missingtags.length;
                int n2 = 0;
                while (n2 < n) {
                    String missingtag = stringArray[n2];
                    newtag = this.createNewTagElement(ast, missingtag);
                    lrewrite.insertLast((ASTNode)newtag, null);
                    ++n2;
                }
            }
        }

        private TagElement createNewTagElement(AST ast, String tagname) {
            TagElement newtag = ast.newTagElement();
            newtag.setTagName(tagname);
            return newtag;
        }

        private String[] collectMissingTags(IApiAnnotations api, List<TagElement> tags, int type, int member) {
            int res = api.getRestrictions();
            ArrayList<String> missing = new ArrayList<String>();
            JavadocTagManager jtm = ApiPlugin.getJavadocTagManager();
            switch (member) {
                case 8: {
                    if (!RestrictionModifiers.isReferenceRestriction(res) || this.containsRestrictionTag(tags, "@noreference")) break;
                    IApiJavadocTag tag = jtm.getTag("org.eclipse.pde.api.tools.noreference");
                    missing.add(tag.getCompleteTag(type, member));
                    break;
                }
                case 4: {
                    IApiJavadocTag tag;
                    if (RestrictionModifiers.isReferenceRestriction(res) && !this.containsRestrictionTag(tags, "@noreference")) {
                        tag = jtm.getTag("org.eclipse.pde.api.tools.noreference");
                        missing.add(tag.getCompleteTag(type, member));
                    }
                    if (!RestrictionModifiers.isOverrideRestriction(res) || this.containsRestrictionTag(tags, "@nooverride")) break;
                    tag = jtm.getTag("org.eclipse.pde.api.tools.nooverride");
                    missing.add(tag.getCompleteTag(type, member));
                    break;
                }
                case 16: {
                    IApiJavadocTag tag;
                    if (RestrictionModifiers.isImplementRestriction(res) && !this.containsRestrictionTag(tags, "@noimplement")) {
                        tag = jtm.getTag("org.eclipse.pde.api.tools.noimplement");
                        missing.add(tag.getCompleteTag(type, member));
                    }
                    if (RestrictionModifiers.isInstantiateRestriction(res) && !this.containsRestrictionTag(tags, "@noinstantiate")) {
                        tag = jtm.getTag("org.eclipse.pde.api.tools.noinstantiate");
                        missing.add(tag.getCompleteTag(type, member));
                    }
                    if (!RestrictionModifiers.isExtendRestriction(res) || this.containsRestrictionTag(tags, "@noextend")) break;
                    tag = jtm.getTag("org.eclipse.pde.api.tools.noextend");
                    missing.add(tag.getCompleteTag(type, member));
                    break;
                }
            }
            return missing.toArray(new String[missing.size()]);
        }

        private boolean containsRestrictionTag(List<TagElement> tags, String tag) {
            return tags.stream().map(AbstractTagElement::getTagName).anyMatch(tag::equals);
        }

        private IElementDescriptor findDescriptorByName(String name, String signature) {
            block5: for (IElementDescriptor desc : this.apis) {
                switch (desc.getElementType()) {
                    case 2: {
                        if (!((IReferenceTypeDescriptor)desc).getName().equals(name)) break;
                        return desc;
                    }
                    case 6: {
                        IMethodDescriptor method = (IMethodDescriptor)desc;
                        if (!method.getName().equals(name) || !method.getSignature().equals(signature)) continue block5;
                        return desc;
                    }
                    case 5: {
                        if (!((IFieldDescriptor)desc).getName().equals(name)) break;
                        return desc;
                    }
                }
            }
            return null;
        }
    }

    static class DescriptionVisitor
    extends ApiDescriptionVisitor {
        private IApiDescription apiDescription = null;
        private IJavaProject project = null;
        private Map<IFile, Set<TextEdit>> fCollector = null;
        private final List<IElementDescriptor> members = new ArrayList<IElementDescriptor>();
        private List<IStatus> exceptions = null;

        DescriptionVisitor(IJavaProject jp, IApiDescription cd, Map<IFile, Set<TextEdit>> collector) {
            this.project = jp;
            this.apiDescription = cd;
            this.fCollector = collector;
        }

        @Override
        public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
            return switch (element.getElementType()) {
                case 1 -> true;
                case 2 -> {
                    this.members.clear();
                    this.members.add(element);
                    yield true;
                }
                default -> {
                    this.members.add(element);
                    yield false;
                }
            };
        }

        @Override
        public void endVisitElement(IElementDescriptor element, IApiAnnotations description) {
            if (element.getElementType() == 2) {
                IReferenceTypeDescriptor refType = (IReferenceTypeDescriptor)element;
                try {
                    IReferenceTypeDescriptor topLevelType = refType.getEnclosingType();
                    while (topLevelType != null) {
                        refType = topLevelType;
                        topLevelType = refType.getEnclosingType();
                    }
                    IType type = this.project.findType(refType.getQualifiedName(), (IProgressMonitor)new NullProgressMonitor());
                    IType typeInProject = Util.getTypeInSameJavaProject(type, refType.getQualifiedName(), this.project);
                    if (typeInProject != null) {
                        type = typeInProject;
                    }
                    if (type != null) {
                        ApiDescriptionProcessor.processTagUpdates(type, refType, this.apiDescription, this.members, this.fCollector);
                    }
                }
                catch (CoreException e) {
                    this.addStatus(e.getStatus());
                }
                catch (BadLocationException e) {
                    this.addStatus(Status.error((String)(ScannerMessages.ComponentXMLScanner_0 + element.toString()), (Throwable)e));
                }
                this.members.clear();
            }
        }

        private void addStatus(IStatus status) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList<IStatus>();
            }
            this.exceptions.add(status);
        }

        public IStatus getStatus() {
            if (this.exceptions == null) {
                return Status.OK_STATUS;
            }
            return new MultiStatus("org.eclipse.pde.api.tools", 0, this.exceptions.toArray(new IStatus[this.exceptions.size()]), ScannerMessages.ComponentXMLScanner_1, null);
        }
    }
}

