/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.ApiMarkerResolutionGenerator;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class ProblemExplainIncompatibilityResolution
extends WorkbenchMarkerResolution {
    protected IMarker fBackingMarker = null;

    public ProblemExplainIncompatibilityResolution(IMarker marker) {
        this.fBackingMarker = marker;
    }

    public String getDescription() {
        try {
            String value = (String)this.fBackingMarker.getAttribute("messagearguments");
            String[] args = new String[]{};
            if (value != null) {
                args = value.split("#");
            }
            int id = this.fBackingMarker.getAttribute("problemid", 0);
            return MessageFormat.format(MarkerMessages.ExplainProblemResolution_explain_incompatibility_desc, ApiProblemFactory.getLocalizedMessage((int)ApiProblemFactory.getProblemMessageId((int)id), (String[])args));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_HELP_PAGE");
    }

    public String getLabel() {
        return MarkerMessages.ExplainProblemResolution_explain_incompatibility;
    }

    public void run(IMarker[] markers, IProgressMonitor m) {
        UIJob job = UIJob.create((String)"", monitor -> {
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.displayHelpResource("/org.eclipse.pde.doc.user/reference/api-tooling/api_evolution.htm");
        });
        job.setSystem(true);
        job.schedule();
    }

    public void run(IMarker marker) {
        this.run(new IMarker[]{marker}, null);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                if (Util.isApiProblemMarker((IMarker)marker) && !this.fBackingMarker.equals((Object)marker) && !marker.getType().equals("org.eclipse.pde.api.tools.unused_filters") && ApiMarkerResolutionGenerator.hasExplainProblemResolution(marker)) {
                    mset.add(marker);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        int size = mset.size();
        return mset.toArray(new IMarker[size]);
    }
}

