/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class JavaApplicationLaunchShortcut
extends JavaLaunchShortcut {
    private static boolean isTestCode(IType type) throws JavaModelException {
        IClasspathEntry entry;
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        IJavaProject javaProject = packageFragmentRoot.getJavaProject();
        return javaProject == null || (entry = javaProject.getClasspathEntryFor(packageFragmentRoot.getPath())) == null || entry.isTest();
    }

    /*
     * WARNING - void declaration
     */
    protected IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            Object object2 = object;
            if (object2 instanceof IAdaptable) {
                void adapt;
                IAdaptable cfr_ignored_0 = (IAdaptable)object2;
                IAdaptable cfr_ignored_1 = (IAdaptable)object2;
                IJavaElement element = (IJavaElement)adapt.getAdapter(IJavaElement.class);
                if (element != null) {
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IMember) {
                        void member;
                        IMember cfr_ignored_2 = (IMember)iJavaElement;
                        IMember cfr_ignored_3 = (IMember)iJavaElement;
                        IType type = member.getDeclaringType();
                        if (type != null) {
                            element = type;
                        }
                    }
                    list.add(element);
                }
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    @Override
    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            boolean useQualification = preferenceStore.getBoolean("launch_name_fully_qualified_for_application");
            String prefix = useQualification ? type.getFullyQualifiedName('.') : type.getTypeQualifiedName('.');
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(prefix));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_NAME, this.getModuleName(type));
            if (!JavaApplicationLaunchShortcut.isTestCode(type)) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, true);
            }
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    @Override
    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IType type;
            if (elements.length == 1 && (type = this.isMainMethod(elements[0])) != null) {
                return new IType[]{type};
            }
            IJavaElement[] javaElements = this.getJavaElements(elements);
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            int constraints = 1;
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)(constraints |= 2));
            return engine.searchMainMethods(context, scope, true);
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private IType isMainMethod(Object o) {
        Object object = o;
        if (object instanceof IAdaptable) {
            void adapt;
            IAdaptable iAdaptable = (IAdaptable)object;
            IAdaptable cfr_ignored_0 = (IAdaptable)object;
            IJavaElement element = (IJavaElement)adapt.getAdapter(IJavaElement.class);
            if (element != null && element.getElementType() == 9) {
                try {
                    IMethod method = (IMethod)element;
                    if (method.isMainMethod()) {
                        return method.getDeclaringType();
                    }
                }
                catch (JavaModelException jme) {
                    JDIDebugUIPlugin.log(jme);
                }
            }
        }
        return null;
    }

    @Override
    protected String getTypeSelectionTitle() {
        return LauncherMessages.JavaApplicationLaunchShortcut_0;
    }

    @Override
    protected String getEditorEmptyMessage() {
        return LauncherMessages.JavaApplicationLaunchShortcut_1;
    }

    @Override
    protected String getSelectionEmptyMessage() {
        return LauncherMessages.JavaApplicationLaunchShortcut_2;
    }

    private String getModuleName(IType type) {
        IModuleDescription moduleDescription;
        IJavaElement javaElement = type.getAncestor(3);
        if (javaElement instanceof IPackageFragmentRoot && (moduleDescription = ((IPackageFragmentRoot)javaElement).getModuleDescription()) != null) {
            return moduleDescription.getElementName();
        }
        return "";
    }
}

