/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.dom.TypeAnnotationRewrite;
import org.eclipse.jdt.internal.corext.fix.TypeParametersFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class TypeChangeCorrectionProposalCore
extends LinkedCorrectionProposalCore {
    private final IBinding fBinding;
    private final CompilationUnit fAstRoot;
    private final ITypeBinding fNewType;
    private final ITypeBinding[] fTypeProposals;
    private final ImportRewrite.TypeLocation fTypeLocation;
    private final boolean fIsNewTypeVar;
    private static String VAR_TYPE = "var";

    public TypeChangeCorrectionProposalCore(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean offerSuperTypeProposals, int relevance) {
        this(targetCU, binding, astRoot, newType, false, offerSuperTypeProposals, relevance);
    }

    public TypeChangeCorrectionProposalCore(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding oldType, int relevance) {
        this(targetCU, binding, astRoot, oldType, true, false, relevance);
    }

    public TypeChangeCorrectionProposalCore(ICompilationUnit targetCU, IBinding binding, CompilationUnit astRoot, ITypeBinding newType, boolean isNewTypeVar, boolean offerSuperTypeProposals, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance);
        Assert.isTrue((binding != null && (binding.getKind() == 4 || binding.getKind() == 3) && Bindings.isDeclarationBinding(binding) ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fIsNewTypeVar = isNewTypeVar;
        if (offerSuperTypeProposals) {
            this.fTypeProposals = ASTResolving.getRelaxingTypes(astRoot.getAST(), newType);
            this.sortTypes(this.fTypeProposals);
            this.fNewType = this.fTypeProposals[0];
        } else {
            this.fNewType = !this.fIsNewTypeVar ? newType : null;
            this.fTypeProposals = null;
        }
        String typeName = isNewTypeVar ? VAR_TYPE : (this.containsNestedCapture(this.fNewType, false) ? this.getNewTypeString() : BindingLabelProviderCore.getBindingLabel((IBinding)this.fNewType, 0x200009L));
        if (binding.getKind() == 3) {
            IVariableBinding varBinding = (IVariableBinding)binding;
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(varBinding.getName()), BasicElementLabels.getJavaElementName(typeName)};
            if (varBinding.isField()) {
                this.fTypeLocation = ImportRewrite.TypeLocation.FIELD;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_field_name, args));
            } else if (astRoot.findDeclaringNode(binding) instanceof SingleVariableDeclaration) {
                this.fTypeLocation = ImportRewrite.TypeLocation.PARAMETER;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_param_name, args));
            } else {
                this.fTypeLocation = ImportRewrite.TypeLocation.LOCAL_VARIABLE;
                this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_variable_name, args));
            }
        } else {
            Object[] args = new String[]{binding.getName(), typeName};
            this.fTypeLocation = ImportRewrite.TypeLocation.RETURN_TYPE;
            this.setDisplayName(Messages.format(CorrectionMessages.TypeChangeCompletionProposal_method_name, args));
        }
    }

    private boolean containsNestedCapture(ITypeBinding binding, boolean isNested) {
        if (binding == null || binding.isPrimitive() || binding.isTypeVariable()) {
            return false;
        }
        if (binding.isCapture()) {
            if (isNested) {
                return true;
            }
            return this.containsNestedCapture(binding.getWildcard(), true);
        }
        if (binding.isWildcardType()) {
            return this.containsNestedCapture(binding.getBound(), true);
        }
        if (binding.isArray()) {
            return this.containsNestedCapture(binding.getElementType(), true);
        }
        ITypeBinding[] iTypeBindingArray = binding.getTypeArguments();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            if (this.containsNestedCapture(typeArgument, true)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getNewTypeString() {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        CompilationUnit newRoot = this.fAstRoot;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            ImportRewrite imports = this.createImportRewrite(newRoot);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(newRoot, declNode.getStartPosition(), imports);
            return imports.addImport(this.fNewType, (ImportRewrite.ImportRewriteContext)context);
        }
        return BindingLabelProviderCore.getBindingLabel((IBinding)this.fNewType, 0x200009L);
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        CompilationUnit newRoot = this.fAstRoot;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite(newRoot);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(newRoot, declNode.getStartPosition(), imports);
            ImportRemover remover = new ImportRemover(this.getCompilationUnit().getJavaProject(), newRoot);
            Object type = this.fIsNewTypeVar ? ast.newSimpleType(ast.newName(VAR_TYPE)) : imports.addImport(this.fNewType, ast, (ImportRewrite.ImportRewriteContext)context, this.fTypeLocation);
            if (declNode instanceof MethodDeclaration) {
                TagElement returnTag;
                methodDecl = (MethodDeclaration)declNode;
                Type origReturnType = methodDecl.getReturnType2();
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, type, null);
                DimensionRewrite.removeAllChildren((ASTNode)methodDecl, MethodDeclaration.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)methodDecl, MethodDeclaration.MODIFIERS2_PROPERTY, rewrite, null);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null && origReturnType != null && origReturnType.isPrimitiveType() && ((PrimitiveType)origReturnType).getPrimitiveTypeCode() == PrimitiveType.VOID && (returnTag = JavadocTagsSubProcessorCore.findTag(javadoc, "@return", null)) == null) {
                    returnTag = ast.newTagElement();
                    returnTag.setTagName("@return");
                    TextElement commentStart = ast.newTextElement();
                    returnTag.fragments().add(commentStart);
                    this.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
                    ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                    JavadocTagsSubProcessorCore.insertTag(tagsRewriter, returnTag, null);
                }
            } else if (declNode instanceof AnnotationTypeMemberDeclaration) {
                methodDecl = (AnnotationTypeMemberDeclaration)declNode;
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)AnnotationTypeMemberDeclaration.TYPE_PROPERTY, type, null);
            } else if (declNode instanceof VariableDeclarationFragment) {
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        FieldDeclaration newField = ast.newFieldDeclaration(placeholder);
                        newField.setType((Type)type);
                        AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)fieldDecl.getParent();
                        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                        if (fieldDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newField, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newField, parent, null);
                        }
                    } else {
                        rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY, type, null);
                        DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                        TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)fieldDecl, FieldDeclaration.MODIFIERS2_PROPERTY, rewrite, null);
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                        newStat.setType((Type)type);
                        ListRewrite listRewrite = rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY);
                        if (varDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newStat, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newStat, parent, null);
                        }
                        if (this.fIsNewTypeVar) {
                            this.handledInferredParametrizedType((ASTNode)newStat, declNode, ast, rewrite, imports, context);
                        }
                    } else {
                        oldType = (Type)rewrite.get((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY);
                        rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, type, null);
                        DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                        if (this.fIsNewTypeVar) {
                            this.handledInferredParametrizedType(parent, declNode, ast, rewrite, imports, context);
                            TypeAnnotationRewrite.removePureTypeAnnotations(parent, VariableDeclarationStatement.MODIFIERS2_PROPERTY, rewrite, null);
                            if (oldType != null) {
                                remover.registerRemovedNode((ASTNode)oldType);
                            }
                        }
                    }
                } else if (parent instanceof VariableDeclarationExpression) {
                    varDecl = (VariableDeclarationExpression)parent;
                    oldType = (Type)rewrite.get((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY);
                    rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationExpression.TYPE_PROPERTY, type, null);
                    DimensionRewrite.removeAllChildren(declNode, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                    if (this.fIsNewTypeVar) {
                        this.handledInferredParametrizedType(parent, declNode, ast, rewrite, imports, context);
                        TypeAnnotationRewrite.removePureTypeAnnotations(parent, VariableDeclarationExpression.MODIFIERS2_PROPERTY, rewrite, null);
                        if (oldType != null) {
                            remover.registerRemovedNode((ASTNode)oldType);
                        }
                    }
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)declNode;
                Type oldType = (Type)rewrite.get((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY);
                rewrite.set((ASTNode)variableDeclaration, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, type, null);
                DimensionRewrite.removeAllChildren(declNode, SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                TypeAnnotationRewrite.removePureTypeAnnotations(declNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY, rewrite, null);
                if (this.fIsNewTypeVar && oldType != null) {
                    remover.registerRemovedNode((ASTNode)oldType);
                }
            }
            this.addLinkedPosition(rewrite.track((ASTNode)type), true, "type");
            if (this.fTypeProposals != null) {
                ITypeBinding[] iTypeBindingArray = this.fTypeProposals;
                int n = this.fTypeProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding fTypeProposal = iTypeBindingArray[n2];
                    this.addLinkedPositionProposal("type", fTypeProposal);
                    ++n2;
                }
            }
            if (this.fIsNewTypeVar) {
                remover.applyRemoves(imports);
            }
            return rewrite;
        }
        return null;
    }

    private void sortTypes(ITypeBinding[] typeProposals) {
        ITypeBinding oldType = this.fBinding instanceof IMethodBinding ? ((IMethodBinding)this.fBinding).getReturnType() : ((IVariableBinding)this.fBinding).getType();
        if (!oldType.isParameterizedType()) {
            return;
        }
        final ITypeBinding oldTypeDeclaration = oldType.getTypeDeclaration();
        Arrays.sort(typeProposals, new Comparator<ITypeBinding>(){

            @Override
            public int compare(ITypeBinding o1, ITypeBinding o2) {
                return this.rank(o2) - this.rank(o1);
            }

            private int rank(ITypeBinding type) {
                if (type.getTypeDeclaration().equals((Object)oldTypeDeclaration)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void handledInferredParametrizedType(ASTNode node, ASTNode declaringNode, AST ast, ASTRewrite rewrite, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        ClassInstanceCreation creation;
        Type type;
        VariableDeclarationFragment varFrag;
        if (ast == null || rewrite == null || importRewrite == null || context == null) {
            return;
        }
        Expression processNode = null;
        List fragments = null;
        if (node instanceof VariableDeclarationStatement) {
            fragments = ((VariableDeclarationStatement)node).fragments();
        } else if (node instanceof VariableDeclarationExpression) {
            fragments = ((VariableDeclarationExpression)node).fragments();
        }
        if (fragments != null && fragments.size() == 1 && (processNode = (varFrag = (VariableDeclarationFragment)fragments.get(0)).getInitializer()) == null && declaringNode instanceof VariableDeclarationFragment) {
            processNode = ((VariableDeclarationFragment)declaringNode).getInitializer();
        }
        ParameterizedType createdType = null;
        if (processNode instanceof ClassInstanceCreation && (type = (creation = (ClassInstanceCreation)processNode).getType()) instanceof ParameterizedType) {
            createdType = (ParameterizedType)type;
        }
        if (createdType == null) {
            return;
        }
        ArrayList<ASTNode> changedNodes = new ArrayList<ASTNode>();
        node.accept((ASTVisitor)new TypeParametersFixCore.InsertTypeArgumentsVisitor(changedNodes));
        if (changedNodes.isEmpty()) {
            return;
        }
        ITypeBinding binding = createdType.resolveBinding();
        if (binding != null) {
            ListRewrite argumentsRewrite = rewrite.getListRewrite((ASTNode)createdType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            ITypeBinding[] iTypeBindingArray = binding.getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgument = iTypeBindingArray[n2];
                Type argumentNode = importRewrite.addImport(typeArgument, ast, context, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                argumentsRewrite.insertLast((ASTNode)argumentNode, null);
                ++n2;
            }
        }
    }
}

