/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class NLSScanner {
    private static final int InternalTokenNameIdentifier = 5;

    private NLSScanner() {
    }

    public static NLSLine[] scan(ICompilationUnit cu) throws JavaModelException, BadLocationException, InvalidInputException {
        IJavaProject javaProject = cu.getJavaProject();
        IScanner scanner = null;
        if (javaProject != null) {
            String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)sourceLevel, (String)complianceLevel);
        } else {
            scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        }
        return NLSScanner.scan(scanner, cu.getBuffer().getCharacters());
    }

    public static NLSLine[] scan(String s) throws InvalidInputException, BadLocationException {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        return NLSScanner.scan(scanner, s.toCharArray());
    }

    private static NLSLine[] scan(IScanner scanner, char[] content) throws InvalidInputException, BadLocationException {
        ArrayList<NLSLine> lines = new ArrayList<NLSLine>();
        scanner.setSource(content);
        int token = scanner.getNextToken();
        int currentLineNr = -1;
        int previousLineNr = -1;
        NLSLine currentLine = null;
        int nlsElementIndex = 0;
        LinkedList<int[]> insideAnnotation = new LinkedList<int[]>();
        int defaultCounter = 0;
        while (token != 158) {
            switch (token) {
                case 401: {
                    insideAnnotation.add(new int[]{-1});
                    break;
                }
                case 180: {
                    insideAnnotation.clear();
                    break;
                }
                case 5: {
                    if (insideAnnotation.isEmpty()) break;
                    int[] parenCounter = (int[])insideAnnotation.getLast();
                    if (parenCounter[0] == -1) {
                        parenCounter[0] = 0;
                        break;
                    }
                    if (parenCounter[0] != 0) break;
                    insideAnnotation.removeLast();
                    break;
                }
                case 6: {
                    if (insideAnnotation.isEmpty()) break;
                    int[] parenCounter = (int[])insideAnnotation.getLast();
                    if (parenCounter[0] == 0) {
                        parenCounter[0] = -1;
                        break;
                    }
                    if (parenCounter[0] != -1) break;
                    insideAnnotation.removeLast();
                    break;
                }
                case 7: {
                    if (insideAnnotation.isEmpty()) break;
                    int[] nArray = (int[])insideAnnotation.getLast();
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                case 86: {
                    if (insideAnnotation.isEmpty()) break;
                    int[] nArray = (int[])insideAnnotation.getLast();
                    nArray[0] = nArray[0] - 1;
                    int parenCount = nArray[0];
                    if (parenCount > 0) break;
                    insideAnnotation.removeLast();
                    break;
                }
                case 212: {
                    defaultCounter = 1;
                    break;
                }
                case 154: {
                    if (defaultCounter == 1) {
                        defaultCounter = 0;
                        break;
                    }
                    if (defaultCounter <= 0) break;
                    ++defaultCounter;
                    break;
                }
                case 64: {
                    defaultCounter = 0;
                    break;
                }
                case 110: {
                    if (defaultCounter <= 1) break;
                    defaultCounter = 0;
                    break;
                }
                case 45: {
                    if (!insideAnnotation.isEmpty() || defaultCounter != 0) break;
                    currentLineNr = scanner.getLineNumber(scanner.getCurrentTokenStartPosition());
                    if (currentLineNr != previousLineNr) {
                        currentLine = new NLSLine(currentLineNr - 1);
                        lines.add(currentLine);
                        previousLineNr = currentLineNr;
                        nlsElementIndex = 0;
                    }
                    String value = new String(scanner.getCurrentTokenSource());
                    currentLine.add(new NLSElement(value, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenStartPosition(), nlsElementIndex++, false));
                    break;
                }
                case 46: {
                    if (!insideAnnotation.isEmpty() || defaultCounter != 0) break;
                    currentLineNr = scanner.getLineNumber(scanner.getCurrentTokenEndPosition());
                    if (currentLineNr != previousLineNr) {
                        currentLine = new NLSLine(currentLineNr - 1);
                        lines.add(currentLine);
                        previousLineNr = currentLineNr;
                        nlsElementIndex = 0;
                    }
                    String value = new String(scanner.getCurrentTokenSource());
                    currentLine.add(new NLSElement(value, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenStartPosition(), nlsElementIndex++, false));
                    break;
                }
                case 1001: {
                    defaultCounter = 0;
                    if (currentLineNr != scanner.getLineNumber(scanner.getCurrentTokenStartPosition())) break;
                    NLSScanner.parseTags(currentLine, scanner);
                    break;
                }
                case 1000: 
                case 1002: 
                case 1003: {
                    break;
                }
                default: {
                    if (defaultCounter <= 0) break;
                    ++defaultCounter;
                }
            }
            token = scanner.getNextToken();
        }
        NLSLine[] result = lines.toArray(new NLSLine[lines.size()]);
        Document document = new Document(String.valueOf(scanner.getSource()));
        NLSLine[] nLSLineArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            NLSLine element = nLSLineArray[n2];
            NLSScanner.setTagPositions((IDocument)document, element);
            ++n2;
        }
        return result;
    }

    private static void parseTags(NLSLine line, IScanner scanner) {
        String s = new String(scanner.getCurrentTokenSource());
        int pos = s.indexOf("//$NON-NLS-");
        while (pos != -1) {
            int start = pos + NLSElement.TAG_PREFIX_LENGTH;
            int end = s.indexOf("$", start);
            if (end < 0) {
                return;
            }
            String index = s.substring(start, end);
            int i = 0;
            try {
                i = Integer.parseInt(index) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (!line.exists(i)) {
                return;
            }
            NLSElement element = line.get(i);
            element.setTagPosition(scanner.getCurrentTokenStartPosition() + pos, end - pos + 1);
            pos = s.indexOf("//$NON-NLS-", start);
        }
    }

    private static void setTagPositions(IDocument document, NLSLine line) throws BadLocationException {
        IRegion info = document.getLineInformation(line.getLineNumber());
        int defaultValue = info.getOffset() + info.getLength();
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            NLSElement element = elements[i];
            if (!element.hasTag()) {
                element.setTagPosition(NLSScanner.computeInsertOffset(elements, i, defaultValue), 0);
            }
            ++i;
        }
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, int defaultValue) {
        NLSElement previousTagged = NLSScanner.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSScanner.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        return defaultValue;
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            --i;
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex + 1;
        while (i < elements.length) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }
}

