/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.schema;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.ui.dtd.IAttribute;
import org.eclipse.ant.internal.ui.dtd.IDfm;
import org.eclipse.ant.internal.ui.dtd.IElement;
import org.eclipse.ant.internal.ui.dtd.IModel;
import org.eclipse.ant.internal.ui.dtd.ParseError;
import org.eclipse.ant.internal.ui.dtd.schema.Atom;
import org.eclipse.ant.internal.ui.dtd.schema.Dfm;
import org.eclipse.ant.internal.ui.dtd.schema.Nfm;
import org.eclipse.ant.internal.ui.dtd.schema.NfmParser;

public class Element
extends Atom
implements IElement {
    private boolean fUndefined = true;
    private boolean fText;
    private IModel fModel;
    private final Map<String, IAttribute> fMap = new HashMap<String, IAttribute>(4);
    private Dfm fElementDfm;
    private static final NfmParser fNfmParser = new NfmParser();
    private boolean fAny;
    private boolean fEmpty;

    public Element(String name) {
        super(0, name);
    }

    public void setUndefined(boolean undefined) {
        this.fUndefined = undefined;
    }

    public void setText(boolean text) {
        this.fText = text;
    }

    public void setContentModel(IModel model) {
        this.fModel = model;
    }

    public void addAttribute(IAttribute attribute) {
        this.fMap.put(attribute.getName(), attribute);
    }

    @Override
    public Map<String, IAttribute> getAttributes() {
        return this.fMap;
    }

    @Override
    public IModel getContentModel() {
        return this.fModel;
    }

    @Override
    public boolean isText() {
        return this.fText;
    }

    @Override
    public boolean isUndefined() {
        return this.fUndefined;
    }

    @Override
    public IDfm getDfm() {
        Dfm dfm = this.fElementDfm;
        if (dfm == null) {
            this.fElementDfm = dfm = this.parseElementDfm();
        }
        return dfm;
    }

    private Dfm parseElementDfm() {
        Dfm dfm;
        if (this.fAny) {
            dfm = Dfm.dfm(true);
            dfm.any = true;
        } else if (this.fEmpty || this.fText) {
            dfm = Dfm.dfm(true);
            dfm.empty = true;
        } else {
            dfm = this.parseModel(this.fModel);
        }
        return dfm;
    }

    private Dfm parseModel(IModel model) {
        Dfm dfm;
        Nfm nfm = model.toNfm();
        if (nfm != null) {
            try {
                dfm = fNfmParser.parse(nfm);
            }
            catch (ParseError parseError) {
                dfm = Dfm.dfm(false);
            }
        } else {
            dfm = Dfm.dfm(false);
        }
        return dfm;
    }

    @Override
    public boolean isAny() {
        return this.fAny;
    }

    @Override
    public boolean isEmpty() {
        return this.fEmpty;
    }

    public void setAny(boolean any) {
        this.fAny = any;
    }

    public void setEmpty(boolean empty) {
        this.fEmpty = empty;
    }
}

