/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.formatting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.formatting2.FormatterPreferenceValuesProvider;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeModelBasedRegionAccessBuilder;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XcoreFormatterFactory
implements IContentFormatterFactory {
    @Inject
    private XcoreContentFormatter formatter;

    public IContentFormatter createConfiguredFormatter(SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        return this.formatter;
    }

    public static class XcoreContentFormatter
    implements IContentFormatter {
        @Inject
        protected IFormatter2 formatter;
        @Inject
        private FormatterPreferenceValuesProvider preferencesProvider;

        public void format(IDocument document, final IRegion region) {
            IXtextDocument xtextDocument = (IXtextDocument)document;
            TextEdit textEdit = (TextEdit)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<TextEdit, XtextResource>(){

                public TextEdit exec(XtextResource xtextResource) throws Exception {
                    IParseResult parseResult = xtextResource.getParseResult();
                    if (parseResult == null) {
                        return null;
                    }
                    IPreferenceValues configuration = preferencesProvider.getPreferenceValues((Resource)xtextResource);
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    try {
                        FormatterRequest request = new FormatterRequest();
                        request.setTextRegionAccess((ITextRegionAccess)new NodeModelBasedRegionAccessBuilder().withResource(xtextResource).create());
                        request.addRegion((ITextRegion)new TextRegion(region.getOffset(), region.getLength()));
                        request.setPreferences(TypedPreferenceValues.castOrWrap((IPreferenceValues)configuration));
                        List edits = formatter.format(request);
                        for (ITextReplacement replacement : edits) {
                            String replacementText = replacement.getReplacementText();
                            if (replacementText.equals(replacement.getText())) continue;
                            multiTextEdit.addChild((TextEdit)new ReplaceEdit(replacement.getOffset(), replacement.getLength(), replacementText));
                        }
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return multiTextEdit;
                }
            });
            try {
                if (textEdit != null) {
                    textEdit.apply(document);
                }
            }
            catch (BadLocationException exception) {
                throw new RuntimeException(exception);
            }
        }

        public IFormattingStrategy getFormattingStrategy(String contentType) {
            return null;
        }
    }
}

