/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.DynamicModelWizard;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CreateDynamicInstanceHandler
extends AbstractHandler {
    protected static final URI PLATFORM_RESOURCE = URI.createPlatformResourceURI((String)"/", (boolean)false);
    @Inject
    protected EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private XcoreMapper mapper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        final ITextSelection selection = (ITextSelection)xtextEditor.getSelectionProvider().getSelection();
        xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(XtextResource localResource) throws Exception {
                EClass eClass;
                EObject element = CreateDynamicInstanceHandler.this.eObjectAtOffsetHelper.resolveElementAt(localResource, selection.getOffset());
                if (element instanceof XClass && (eClass = (EClass)CreateDynamicInstanceHandler.this.mapper.getEcore((XNamedElement)((XClass)element))) != null) {
                    IFile file;
                    URI uri = eClass.eResource().getURI();
                    StructuredSelection selection2 = StructuredSelection.EMPTY;
                    if (uri != null && uri.isHierarchical() && (uri.isRelative() || (uri = uri.deresolve(PLATFORM_RESOURCE)).isRelative()) && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()))).exists()) {
                        selection2 = new StructuredSelection((Object)file);
                    }
                    DynamicModelWizard dynamicModelWizard = new DynamicModelWizard(eClass);
                    dynamicModelWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection2);
                    WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)dynamicModelWizard);
                    wizardDialog.open();
                }
                return null;
            }
        });
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        Object activeEditor;
        boolean isEnabled = false;
        if (evaluationContext instanceof IEvaluationContext && (activeEditor = ((IEvaluationContext)evaluationContext).getVariable("activeEditor")) instanceof XtextEditor) {
            XtextEditor xtextEditor = (XtextEditor)activeEditor;
            final ITextSelection selection = (ITextSelection)xtextEditor.getSelectionProvider().getSelection();
            isEnabled = (Boolean)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource localResource) throws Exception {
                    EClass eClass;
                    EObject element = CreateDynamicInstanceHandler.this.eObjectAtOffsetHelper.resolveElementAt(localResource, selection.getOffset());
                    if (element instanceof XClass && (eClass = (EClass)CreateDynamicInstanceHandler.this.mapper.getEcore((XNamedElement)((XClass)element))) != null) {
                        return true;
                    }
                    return false;
                }
            });
        }
        this.setBaseEnabled(isEnabled);
    }
}

