/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.openregspecs.dsl.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.efbt.openregspecs.dsl.services.XCoreLiteGrammarAccess;
import org.eclipse.efbt.xcorelite.model.xcorelite.Import;
import org.eclipse.efbt.xcorelite.model.xcorelite.XClass;
import org.eclipse.efbt.xcorelite.model.xcorelite.XClassifier;
import org.eclipse.efbt.xcorelite.model.xcorelite.XMember;
import org.eclipse.efbt.xcorelite.model.xcorelite.XPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

public class XCoreLiteFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private XCoreLiteGrammarAccess _xCoreLiteGrammarAccess;

    protected void _format(XPackage xPackage, @Extension IFormattableDocument document) {
        EList _imports = xPackage.getImports();
        for (Import _import : _imports) {
            document.format((Object)_import);
        }
        EList _classifiers = xPackage.getClassifiers();
        for (XClassifier xClassifier : _classifiers) {
            document.format((Object)xClassifier);
        }
    }

    protected void _format(XClass xClass, @Extension IFormattableDocument document) {
        EList _members = xClass.getMembers();
        for (XMember xMember : _members) {
            document.format((Object)xMember);
        }
    }

    public void format(Object xClass, IFormattableDocument document) {
        if (xClass instanceof XClass) {
            this._format((XClass)xClass, document);
            return;
        }
        if (xClass instanceof XtextResource) {
            this._format((XtextResource)xClass, document);
            return;
        }
        if (xClass instanceof XPackage) {
            this._format((XPackage)xClass, document);
            return;
        }
        if (xClass instanceof EObject) {
            this._format((EObject)xClass, document);
            return;
        }
        if (xClass == null) {
            this._format(null, document);
            return;
        }
        if (xClass != null) {
            this._format(xClass, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xClass, document).toString());
    }
}

