/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class ChangeSetLabelDecorator
extends LabelProvider
implements ILabelDecorator,
IFontDecorator {
    private Font boldFont;
    private ActiveChangeSetManager collector;

    public ChangeSetLabelDecorator(ISynchronizePageConfiguration configuration) {
        ISynchronizeParticipant participant = configuration.getParticipant();
        if (participant instanceof IChangeSetProvider) {
            this.collector = ((IChangeSetProvider)((Object)participant)).getChangeSetCapability().getActiveChangeSetManager();
        }
    }

    public String decorateText(String input, Object element) {
        ChangeSet set;
        String text = input;
        if (element instanceof ChangeSetDiffNode && (set = ((ChangeSetDiffNode)element).getSet()) instanceof ActiveChangeSet && this.isDefaultActiveSet((ActiveChangeSet)set)) {
            text = NLS.bind((String)TeamUIMessages.CommitSetDiffNode_0, (Object[])new String[]{text});
        }
        return text;
    }

    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
    }

    public Font decorateFont(Object element) {
        ChangeSet set;
        if (element instanceof ChangeSetDiffNode && (set = ((ChangeSetDiffNode)element).getSet()) instanceof ActiveChangeSet && this.isDefaultActiveSet((ActiveChangeSet)set)) {
            if (this.boldFont == null) {
                FontData[] data;
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] fontDataArray = data = defaultFont.getFontData();
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    FontData d = fontDataArray[n2];
                    d.setStyle(1);
                    ++n2;
                }
                this.boldFont = new Font((Device)TeamUIPlugin.getStandardDisplay(), data);
            }
            return this.boldFont;
        }
        return null;
    }

    private boolean isDefaultActiveSet(ActiveChangeSet set) {
        return this.collector.isDefault(set);
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }
}

