/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.client.handler;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.client.handler.Handler;
import servlet.tck.common.request.Header;

public class LocationHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationHandler.class);
    private static Handler handler = new LocationHandler();

    private LocationHandler() {
    }

    public static Handler getInstance() {
        return handler;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        boolean pass = true;
        try {
            LOGGER.trace("[LocationHandler] LocationHandler invoked.");
            URL configURL = new URL(configuredHeader.getValue());
            URL responseURL = new URL(responseHeader.getValue());
            if (!configURL.getProtocol().equals(responseURL.getProtocol())) {
                pass = false;
                LOGGER.error("[LocationHandler] Mismatch between protocols:");
                LOGGER.error("[LocationHandler] Configured value: {}", (Object)configURL.getProtocol());
                LOGGER.error("[LocationHandler] Response value: {}", (Object)responseURL.getProtocol());
            }
            if (!configURL.getPath().equals(responseURL.getPath())) {
                pass = false;
                LOGGER.error("[LocationHandler] Mismatch between paths:");
                LOGGER.error("[LocationHandler] Configured value: {}", (Object)configURL.getPath());
                LOGGER.error("[LocationHandler] Response value: {}", (Object)responseURL.getPath());
            }
            if (configURL.getQuery() == null) {
                if (responseURL.getQuery() != null) {
                    pass = false;
                    LOGGER.error("[LocationHandler] Mismatch between queries:");
                    LOGGER.error("[LocationHandler] Configured value is null");
                    LOGGER.error("[LocationHandler] Response value is non-null");
                }
            } else if (!configURL.getQuery().equals(responseURL.getQuery())) {
                pass = false;
                LOGGER.error("[LocationHandler] Mismatch between queries:");
                LOGGER.error("[LocationHandler] Configured value: {}", (Object)configURL.getQuery());
                LOGGER.error("[LocationHandler] Response value: {}", (Object)responseURL.getQuery());
            }
        }
        catch (MalformedURLException mue) {
            pass = false;
            LOGGER.error("[LocationHandler] MalformedURLException", (Throwable)mue);
        }
        return pass;
    }
}

