/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.request;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.request.ValidationStrategy;

public class ValidationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationFactory.class);

    private ValidationFactory() {
    }

    public static ValidationStrategy getInstance(String validator) {
        try {
            Object o = Thread.currentThread().getContextClassLoader().loadClass(validator).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (o instanceof ValidationStrategy) {
                return (ValidationStrategy)o;
            }
        }
        catch (Throwable t) {
            LOGGER.info("[ValidationFactory] Unable to obtain ValidationStrategy instance: {}", (Object)validator);
        }
        return null;
    }
}

