/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.scattributeevent;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import servlet.tck.common.util.StaticLog;

public final class SCAttributeListener
implements ServletContextAttributeListener,
ServletContextListener {
    static ServletContext savedSC = null;

    public void contextInitialized(ServletContextEvent event) {
        savedSC = event.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeAdded:" + event.getName() + "," + String.valueOf(event.getValue()));
        ServletContext sc = event.getServletContext();
        if (savedSC != sc) {
            StaticLog.add(this.getErrorMessageForInvalidContext(savedSC, sc));
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeRemoved:" + event.getName() + "," + String.valueOf(event.getValue()));
        ServletContext sc = event.getServletContext();
        if (savedSC != sc) {
            StaticLog.add(this.getErrorMessageForInvalidContext(savedSC, sc));
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeReplaced:" + event.getName() + "," + String.valueOf(event.getValue()));
        ServletContext sc = event.getServletContext();
        if (savedSC != sc) {
            StaticLog.add(this.getErrorMessageForInvalidContext(savedSC, sc));
        }
    }

    private String getErrorMessageForInvalidContext(ServletContext initCtx, ServletContext eventCtx) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("The ServletContext of the event is not the same ServletContext provided to the listener at initialization.\n");
        sb.append("Initialized context: " + String.valueOf(initCtx) + "\n");
        sb.append("Event.getServletContext returned context: " + String.valueOf(eventCtx) + "\n");
        return sb.toString();
    }
}

