/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.i18n.encoding;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import servlet.tck.common.servlets.HttpTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends HttpTCKServlet {
    public void spec1Test(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        String[] call = new String[]{"setContentType", "setLocale", "setCharacterEncoding", "getWriter", "setCharacterEncoding", "setLocale"};
        String[] actual = new String[6];
        String[] expected = new String[]{"utf-16le", "utf-16le", "utf-8", "utf-8", "utf-8", "utf-8"};
        try {
            response.setContentType("text/html;charset=utf-16le");
            actual[0] = response.getCharacterEncoding();
            response.setLocale(Locale.JAPAN);
            actual[1] = response.getCharacterEncoding();
            response.setCharacterEncoding("utf-8");
            actual[2] = response.getCharacterEncoding();
            PrintWriter pw = response.getWriter();
            actual[3] = response.getCharacterEncoding();
            response.setCharacterEncoding("iso-8859-1");
            actual[4] = response.getCharacterEncoding();
            response.setLocale(Locale.JAPAN);
            actual[5] = response.getCharacterEncoding();
            for (int i = 0; i < actual.length; ++i) {
                if (actual[i].toLowerCase(Locale.US).equals(expected[i].toLowerCase(Locale.US))) continue;
                passed = false;
                pw.println("Error: Step:" + i + " - encoding after " + call[i] + " is " + actual[i] + "; expected " + expected[i]);
            }
            ServletTestUtil.printResult(pw, passed);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void spec2Test(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        String[] call = new String[]{"setContentType", "setLocale", "setLocale", "setContentType", "setCharacterEncoding", "setLocale", "setContentType", "setCharacterEncoding", "getWriter", "setCharacterEncoding", "setLocale"};
        String[] actual = new String[11];
        String[] expected = new String[]{"iso-8859-1", "euc-jp", "gb18030", "gb18030", "utf-8", "utf-8", "gb18030", "utf-8", "utf-8", "utf-8", "utf-8"};
        try {
            response.setContentType("text/html");
            actual[0] = response.getCharacterEncoding();
            response.setLocale(Locale.JAPAN);
            actual[1] = response.getCharacterEncoding();
            response.setLocale(Locale.CHINA);
            actual[2] = response.getCharacterEncoding();
            response.setContentType("text/html");
            actual[3] = response.getCharacterEncoding();
            response.setCharacterEncoding("utf-8");
            actual[4] = response.getCharacterEncoding();
            response.setLocale(Locale.JAPAN);
            actual[5] = response.getCharacterEncoding();
            response.setContentType("text/html;charset=gb18030");
            actual[6] = response.getCharacterEncoding();
            response.setCharacterEncoding("utf-8");
            actual[7] = response.getCharacterEncoding();
            PrintWriter pw = response.getWriter();
            actual[8] = response.getCharacterEncoding();
            response.setCharacterEncoding("iso-8859-1");
            actual[9] = response.getCharacterEncoding();
            response.setLocale(Locale.JAPAN);
            actual[10] = response.getCharacterEncoding();
            for (int i = 0; i < actual.length; ++i) {
                if (actual[i].toLowerCase(Locale.US).equals(expected[i].toLowerCase(Locale.US))) continue;
                passed = false;
                pw.println("Error: Step:" + (i + 1) + " - encoding after " + call[i] + " is " + actual[i] + "; expected " + expected[i]);
            }
            ServletTestUtil.printResult(pw, passed);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void spec3Test(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        String[] call = new String[]{"setContentType", "flushBuffer", "setCharacterEncoding", "setLocale", "getWriter"};
        String[] actual = new String[5];
        String[] expected = new String[]{"iso-8859-1", "iso-8859-1", "iso-8859-1", "iso-8859-1", "iso-8859-1"};
        try {
            response.setContentType("text/html");
            actual[0] = response.getCharacterEncoding();
            response.flushBuffer();
            actual[1] = response.getCharacterEncoding();
            response.setCharacterEncoding("utf-8");
            actual[2] = response.getCharacterEncoding();
            response.setLocale(Locale.JAPAN);
            actual[3] = response.getCharacterEncoding();
            PrintWriter pw = response.getWriter();
            actual[4] = response.getCharacterEncoding();
            for (int i = 0; i < actual.length; ++i) {
                if (actual[i].toLowerCase(Locale.US).equals(expected[i].toLowerCase(Locale.US))) continue;
                passed = false;
                pw.println("Error: Step:" + i + " - encoding after " + call[i] + " is " + actual[i] + "; expected " + expected[i]);
            }
            ServletTestUtil.printResult(pw, passed);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }
}

