/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.servletcontext305;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import servlet.tck.common.servlets.GenericTCKServlet;
import servlet.tck.common.util.ServletTestUtil;
import servlet.tck.common.util.StaticLog;

public class TestServlet
extends GenericTCKServlet {
    public void testAddFilterString(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/addServletString";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.forward(request, response);
        }
        catch (Exception ex) {
            response.getWriter().println("Got Exception in testAddFilterString: " + ex.getMessage());
        }
        response.flushBuffer();
        this.getServletContext().removeAttribute("arraylist");
    }

    public void testAddFilterClass(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String path = "/SecondaddServletClass";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(request, response);
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception in testAddFilterClass: " + ex.getMessage());
        }
        this.sendtoclient(response);
    }

    public void testCreateFilterForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String path = "/SecondCreateServlet";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.forward(request, response);
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception in testCreateFilterForward: " + ex.getMessage());
        }
        ServletTestUtil.printResult(pw, passed);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void testCreateFilterInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String path = "/ThirdCreateServlet";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(request, response);
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception in testCreateFilterInclude: " + ex.getMessage());
        }
        this.sendtoclient(response);
    }

    public void testCreateSRAListener(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/ThirdAddServletClass";
        request.setAttribute("TestCreateSRAListener", (Object)"See_what_happens");
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(request, response);
        }
        catch (Exception ex) {
            response.getWriter().println("Got Exception in TestCreateSRAListener: " + ex.getMessage());
        }
        this.sendtoclient(response);
    }

    public void negativeCreateTests(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String[] names;
        PrintWriter pw = response.getWriter();
        for (String name : names = new String[]{"SERVLET_TEST", "FILTER_TEST", "LISTENER_TEST", "GC_LISTENER_TEST", "GS_LISTENER_TEST", "CGC_LISTENER_TEST"}) {
            pw.println(name + "=" + this.getServletContext().getInitParameter(name).toUpperCase());
            this.getServletContext().removeAttribute(name);
        }
        ServletTestUtil.printResult(pw, true);
        this.getServletContext().removeAttribute("arraylist");
    }

    private void sendtoclient(ServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        ArrayList result = (ArrayList)this.getServletContext().getAttribute("arraylist");
        if (result != null) {
            for (Object tmp : result) {
                if (tmp == null) continue;
                pw.println(tmp.toString());
            }
        }
        this.getServletContext().removeAttribute("arraylist");
        result = StaticLog.getClear();
        if (result != null) {
            for (Object tmp : result) {
                if (tmp == null) continue;
                pw.println(tmp.toString());
            }
        }
        StaticLog.clear();
        ServletTestUtil.printResult(pw, true);
    }
}

