/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.clientwriter.writerinterceptorcontext;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.TextCaser;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.clientwriter.WriterClient;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.clientwriter.writerinterceptorcontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.clientwriter.writerinterceptorcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.ContextOperation;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.OnWriteExceptionThrowingStringBean;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.ProceedException;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.WriterInterceptorOne;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.WriterInterceptorTwo;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends WriterClient<ContextOperation> {
    private static final long serialVersionUID = 2500912584762173255L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_ext_interceptor_clientwriter_writerinterceptorcontext_web/resource");
        this.addProviders();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/ext/interceptor/clientwriter/writerinterceptorcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_ext_interceptor_clientwriter_writerinterceptorcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getEntityTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETENTITY);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Entity");
        this.invoke();
    }

    @Test
    public void getHeadersOperationOnlyTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETHEADERS);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "OPERATION");
        this.invoke();
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        JAXRSCommonClient.Property p = JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING;
        this.setOperationAndEntity(ContextOperation.GETHEADERS);
        this.setProperty(p, "OPERATION");
        this.setTextCaser(TextCaser.LOWER);
        for (int i = 0; i != 5; ++i) {
            this.addHeader("Property" + i, "any");
            this.setProperty(p, "Property" + i);
        }
        this.invoke();
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.GETHEADERSISMUTABLE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Property");
        this.invoke();
    }

    @Test
    public void getOutputStreamTest() throws JAXRSCommonClient.Fault {
        JAXRSCommonClient.Property p = JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING;
        this.setOperationAndEntity(ContextOperation.GETOUTPUTSTREAM);
        this.setProperty(p, "Entity");
        this.setProperty(p, "None");
        this.invoke();
    }

    @Test
    public void proceedThrowsIOExceptionTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.PROCEEDTHROWSIOEXCEPTION);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IOException has been thrown as expected");
        this.invoke();
    }

    @Test
    public void proceedThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        this.addProvider(StringBeanEntityProvider.class);
        this.addHeader("OPERATION", ContextOperation.PROCEEDTHROWSWEBAPPEXCEPTION.name());
        this.setRequestContentEntity(new OnWriteExceptionThrowingStringBean("Entity"));
        try {
            this.invoke();
        }
        catch (Exception e) {
            ProceedException p = JAXRSClientIT.assertCause(e, ProceedException.class, "Proceed did not throw exception");
            JAXRSClientIT.assertContains(p.getMessage(), "WebApplicationException has been thrown as expected", new Object[]{"Unexpected message received", p.getMessage()});
            JAXRSClientIT.logMsg(p.getMessage());
        }
    }

    @Test
    public void setEntityTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETENTITY);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OPERATION");
        this.invoke();
    }

    @Test
    public void setOutputStreamTest() throws JAXRSCommonClient.Fault {
        this.setOperationAndEntity(ContextOperation.SETOUTPUTSTREAM);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Entity".replace('t', 'x'));
        this.invoke();
    }

    @Override
    protected void addProviders() {
        this.addProvider(new WriterInterceptorTwo());
        this.addProvider(WriterInterceptorOne.class);
    }
}

