/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.attribute;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_core_act_attribute_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_core_act_attribute_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{URLClientIT.class}), new String[]{URLClientIT.class.getPackageName()});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_core_act_attribute_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/attribute.tld", "attribute.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeDuplicatedAttributeTest.jsp")), "JspAttributeDuplicatedAttributeTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeDynamicTest1.jsp")), "JspAttributeDynamicTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeDynamicTest2.jsp")), "JspAttributeDynamicTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeElementInteractionTest.jspx")), "JspAttributeElementInteractionTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeEmptyBodyTest.jsp")), "JspAttributeEmptyBodyTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentNonScrBodyTest1.jsp")), "JspAttributeFragmentNonScrBodyTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentNonScrBodyTest2.jsp")), "JspAttributeFragmentNonScrBodyTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentNonScrBodyTest3.jsp")), "JspAttributeFragmentNonScrBodyTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentNonScrBodyTest4.jsp")), "JspAttributeFragmentNonScrBodyTest4.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentNonScrBodyTest5.jsp")), "JspAttributeFragmentNonScrBodyTest5.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentNonScrBodyTest6.jsp")), "JspAttributeFragmentNonScrBodyTest6.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeFragmentTest.jsp")), "JspAttributeFragmentTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeNameReqAttributeTest.jsp")), "JspAttributeNameReqAttributeTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeNoAttributeFoundTest.jsp")), "JspAttributeNoAttributeFoundTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeQNameTest1.jsp")), "JspAttributeQNameTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeQNameTest2.jsp")), "JspAttributeQNameTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeQNameTest3.jspx")), "JspAttributeQNameTest3.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeQNameTest4.jsp")), "JspAttributeQNameTest4.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeRtTest.jsp")), "JspAttributeRtTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeTrimTest.jsp")), "JspAttributeTrimTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeUsageContextTest1.jsp")), "JspAttributeUsageContextTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeUsageContextTest2.jspx")), "JspAttributeUsageContextTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspAttributeUsageContextTest3.jsp")), "JspAttributeUsageContextTest3.jsp");
        return archive;
    }

    @Test
    public void jspAttributeFragmentTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspAttributeUsageContextTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeUsageContextTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeUsageContextTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeUsageContextTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspAttributeFragmentNonScriptingBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentNonScrBodyTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentNonScrBodyTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentNonScrBodyTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentNonScrBodyTest4.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentNonScrBodyTest5.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeFragmentNonScrBodyTest6.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspAttributeDynamicAttributesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeDynamicTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeDynamicTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspAttributeRtExprTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeRtTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED|Test PASSED|Test PASSED|Test PASSED|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspAttributeElementInteractionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeElementInteractionTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<test name=|passed|Test PASSED|</test>");
        this.invoke();
    }

    @Test
    public void jspAttributeTrimTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeTrimTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED|Test PASSED|Test PASSED|Test PASSED|Test PASSED");
        this.invoke();
    }

    @Test
    public void jspAttributeDuplicatedAttributeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeDuplicatedAttributeTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspAttributeQNameTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeQNameTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeQNameTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeQNameTest3.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<test test:status=|passed|Test PASSED|</test>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeQNameTest4.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "dynamic|dynamic value");
        this.invoke();
    }

    @Test
    public void jspAttributeEmptyBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeEmptyBodyTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED");
        this.invoke();
    }

    @Test
    public void jspAttributeNoAttributeFoundTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeNoAttributeFoundTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspAttributeNameRequiredAttributeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_attribute_web/JspAttributeNameReqAttributeTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

