/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client.http;

import ee.jakarta.tck.pages.common.porting.TSURL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class MethodFactory {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String OPTIONS_METHOD = "OPTIONS";
    private static final TSURL TS_URL = new TSURL();

    private MethodFactory() {
    }

    public static HttpUriRequest getInstance(String requestLine) {
        HttpGet req;
        String version;
        String uri;
        String method;
        StringTokenizer st = new StringTokenizer(requestLine);
        try {
            method = st.nextToken();
            uri = TS_URL.getRequest(st.nextToken());
            version = st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("Request provided: " + requestLine + " is malformed.");
        }
        if (method.equals(GET_METHOD)) {
            req = new HttpGet(uri);
        } else if (method.equals(POST_METHOD)) {
            req = new HttpPost(uri);
        } else if (method.equals(PUT_METHOD)) {
            req = new HttpPut(uri);
        } else if (method.equals(DELETE_METHOD)) {
            req = new HttpDelete(uri);
        } else if (method.equals(HEAD_METHOD)) {
            req = new HttpHead(uri);
        } else if (method.equals(OPTIONS_METHOD)) {
            req = new HttpOptions(uri);
        } else {
            throw new IllegalArgumentException("Invalid method: " + method);
        }
        MethodFactory.setHttpVersion(version, (HttpRequestBase)req);
        return req;
    }

    private static void setHttpVersion(String version, HttpRequestBase method) {
        String oneOne = "HTTP/1.1";
        HttpVersion protocolVersion = version.equals("HTTP/1.1") ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0;
        method.setProtocolVersion((ProtocolVersion)protocolVersion);
    }
}

