/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.taglibraryvalidator;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.taglibraryvalidator.APIValidator;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.taglibraryvalidator.FailingValidator;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_taglibvalidator_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_taglibvalidator_web.war");
        archive.addClasses(new Class[]{APIValidator.class, FailingValidator.class, JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_taglibvalidator_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/taglibvalfail.tld", "taglibvalfail.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/taglibvalidator.tld", "taglibvalidator.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TLVTranslationErrorTest.jsp")), "TLVTranslationErrorTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TagLibraryValidatorTest.jsp")), "TagLibraryValidatorTest.jsp");
        return archive;
    }

    @Test
    public void tagLibraryValidatorAPITest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_taglibvalidator_web/TagLibraryValidatorTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        TEST_PROPS.setProperty("search_string", "Test PASSED.  Validator call count was 1");
        this.invoke();
    }

    @Test
    public void tagLibraryValidatorTranslationFailureTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_taglibvalidator_web/TLVTranslationErrorTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }
}

