/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCClient.java 74522 2015-06-02 12:05:10Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.ppsrv.nomoreendpoints;

import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 *                     ws_wait;
 *                     tslib.name;
 */
/**
 * @OnMessage can contain one text message handling method. This test
 *            checks two such methods fail the deployment.
 * @since 1.11
 */
public class WSCClient extends NegativeDeploymentClient {

	private static final long serialVersionUID = 111L;

	public WSCClient() {
		setContextRoot("wsc_negdep_onmessage_ppsrv_nomoreendpoints_web");
	}

	public static void main(String[] args) {
		new WSCClient().run(args);
	}

	/*
	 * @testName: duplicateOnMessagePreventOtherEndpointFromBeingDeployedTest
	 * @assertion_ids:  WebSocket:SPEC:WSC-5.2.1-3;WebSocket:SPEC:WSC-4.7-4;
	 * @test_Strategy: In both cases, a deployment error raised during the 
	 * deployment process must halt the deployment of the application, any 
	 * well formed endpoints deployed prior to the error being raised must be 
	 * removed from service and no more websocket endpoints from that 
	 * application may be deployed by the container, even if they are valid.
	 * 
	 * Each websocket endpoint may only have one message handling method for 
	 * each of the native websocket message formats: text, binary and pong. 
	 * The websocket implementation must not deploy such an endpoint and must 
	 * raise a deployment error if an attempt is made to deploy such an 
	 * annotated endpoint. [WSC-4.7-4]
	 * 
	 * To check the test fails when deployment pass, comment out of the 
	 * @OnMessage of OnMessageServerEndpoint  
	 */
	public void duplicateOnMessagePreventOtherEndpointFromBeingDeployedTest() throws Fault {
		setProperty(Property.CONTENT, "anything");
		setProperty(Property.REQUEST, buildRequest("echo"));
		setProperty(Property.STATUS_CODE, "-1");
		// logExceptionOnInvocation(false);
		try {
			invoke(false);
		} catch (Fault tfe) {
			// DeploymentException
		}
		String response = getResponseAsString();
		if ("anything".equals(response))
			throwValidEndpointMustBeRemoved();
	}
}
