/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnMessageClientEndpoint.java 74509 2015-05-25 13:33:41Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.client.textreaderboolean;

import java.io.IOException;
import java.io.Reader;

import javax.websocket.ClientEndpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ClientEndpoint
public class OnMessageClientEndpoint extends AnnotatedStringClientEndpoint {

	@OnMessage
	public void onMessage(Reader reader, boolean finito) throws IOException {
		clientEndpoint.onMessage(IOUtil.readFromReader(reader));
	}

	@OnError
	public void onError(Session session, Throwable t) {
		clientEndpoint.onError(session, t);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		clientEndpoint.onOpen(session, config, false);
	}
}
