/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnOpenServerEndpoint.java 74522 2015-06-02 12:05:10Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.invalidpathparamtype.pasrv.onopen;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/invalid/{arg}", decoders = { StringBeanTextDecoder.class })
public class OnOpenServerEndpoint {
	private String open;

	@OnMessage
	public String echo(String echo) {
		return open + echo;
	}

	// This header makes the endpoint invalid, since only Strings can be
	// @PathParams	
	@OnOpen
	public void onOpen(Session session, @PathParam("arg") StringBean sb) {
		open = sb.get();
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}
}
