/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSPongMessageAndPathParamServer.java 72269 2013-06-29 02:00:44Z djiao $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/pongmessagepathparam/{param}")
public class WSPongMessageAndPathParamServer {

	@OnMessage
	public String echo(PongMessage msg, @PathParam("param") String param) {
		return IOUtil.byteBufferToString(msg.getApplicationData()) + param;
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in " + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}
}
