/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSByteArrayPartialAndSessionAndPathParamServer.java 70745 2013-03-15 22:18:24Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/partialbytearraysessionpathparam/{param}")
public class WSByteArrayPartialAndSessionAndPathParamServer {

	StringBuffer sb = new StringBuffer();

	@OnMessage
	public void bytesToString(@PathParam("param") String param, byte[] array,
			Session s, boolean finito) throws IOException {
		sb.append(new String(array)).append("(").append(finito).append(")");
		sb.append('[').append(param).append("]");
		if (finito) {
			s.getBasicRemote().sendText(sb.toString());
			sb = new StringBuffer();
		}
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in" + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}
}
