/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ThrowingTextDecoder.java 72879 2013-09-19 15:25:02Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder;

import javax.websocket.DecodeException;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;

public class ThrowingTextDecoder extends StringBeanTextDecoder {
	public static final String ERR_MSG = "TCK coder exception for test";
	public static final String IO_ERR_MSG = "TCK IO exception for test";

	@Override
	public StringBean decode(String s) throws DecodeException {
		throw new DecodeException(s, ERR_MSG);
	}

	public static String getCauseMessage(Throwable t) {
		String msg = null;
		while (t != null) {
			msg = t.getMessage();
			t = t.getCause();
		}
		return msg;
	}
}
