/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteBufferPartialMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ByteBufferPartialMessageHandler implements
		MessageHandler.Partial<ByteBuffer> {

	private Session session;
	public static final String HANDLER_SAYS = "ByteBufferPartialMessageHandler says: ";
	StringBuilder sb = new StringBuilder();

	public ByteBufferPartialMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(ByteBuffer message, boolean finite) {
		sb.append(IOUtil.byteBufferToString(message));
		try {
			if (finite)
				session.getBasicRemote().sendText(HANDLER_SAYS + sb.toString());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
