/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InputStreamMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.io.InputStream;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class InputStreamMessageHandler implements
		MessageHandler.Whole<InputStream> {

	ClientEndpoint<String> endpoint;
	public static final String HANDLER_SAYS = "InputStreamMessageHandler says: ";

	public InputStreamMessageHandler(ClientEndpoint<String> endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(InputStream message) {
		try {
			endpoint.onMessage(HANDLER_SAYS + IOUtil.readFromStream(message));
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
