/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.asyncwithhandler;

import java.io.IOException;

import javax.websocket.EncodeException;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderBool;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderByte;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderChar;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderDouble;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderFloat;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderInt;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderLong;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextStreamCoderShort;

@ServerEndpoint(value = "/textstream", encoders = { TextStreamCoderBool.class,
		TextStreamCoderByte.class, TextStreamCoderChar.class,
		TextStreamCoderDouble.class, TextStreamCoderInt.class,
		TextStreamCoderLong.class, TextStreamCoderFloat.class,
		TextStreamCoderShort.class })
public class WSCTextStreamServer extends WSCCommonServer {

	@OnMessage
	public void onMessage(String msg, Session session) throws IOException,
			EncodeException {
		super.onMessage(msg, session);
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		super.onError(session, t);
	}
}
