/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCErrorServerEndpoint.java 72835 2013-09-09 16:00:58Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.endpoint.server;

import java.io.IOException;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class WSCErrorServerEndpoint extends Endpoint implements
		MessageHandler.Whole<String> {
	static final String EXCEPTION = "TCK test throwable";
	private Session session;

	@Override
	public void onMessage(String msg) {
		session.getAsyncRemote().sendText(msg);
		throw new RuntimeException(EXCEPTION);
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		session.addMessageHandler(this);
		this.session = session;
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@Override
	public void onError(Session session, Throwable t) {
		String msg = getCauseMessage(t);
		if (EXCEPTION.equals(msg)) {
			WSCMsgServer.setLastMessage(EXCEPTION);
		} else {
			t.printStackTrace(); // Write to error log, too
			String message = IOUtil.printStackTrace(t);
			try {
				session.getBasicRemote().sendText(message);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private static String getCauseMessage(Throwable t) {
		String msg = null;
		while (t != null) {
			msg = t.getMessage();
			t = t.getCause();
		}
		return msg;
	}

}
