/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCEndpointWithTextStreamEncoder.java 72711 2013-08-27 10:37:08Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;

@ClientEndpoint(encoders = InitDestroyTextStreamEncoder.class)
public class WSCEndpointWithTextStreamEncoder extends
		AnnotatedClientEndpoint<String> {

	public WSCEndpointWithTextStreamEncoder() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

}
