/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: StringBeanTextStreamDecoder.java 70531 2013-03-10 14:38:04Z djiao $
 */

package com.sun.ts.tests.websocket.common.stringbean;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import java.io.IOException;
import java.io.Reader;
import javax.websocket.DecodeException;
import javax.websocket.Decoder.TextStream;
import javax.websocket.EndpointConfig;

public class StringBeanTextStreamDecoder implements TextStream<StringBean> {

    @Override
    public void init(EndpointConfig config) {
    }

    @Override
    public StringBean decode(Reader r) throws DecodeException, IOException {
        String text = IOUtil.readFromReader(r);
        return new StringBean(text);
    }

    @Override
    public void destroy() {
    }
}
