/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: StringBeanBinaryStreamDecoder.java 70531 2013-03-10 14:38:04Z djiao $
 */

package com.sun.ts.tests.websocket.common.stringbean;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.websocket.DecodeException;
import javax.websocket.Decoder.BinaryStream;
import javax.websocket.EndpointConfig;

public class StringBeanBinaryStreamDecoder implements BinaryStream<StringBean> {

    @Override
    public void init(EndpointConfig config) {
    }

    @Override
    public StringBean decode(InputStream arg0) throws DecodeException,
            IOException {
        String data = IOUtil.readFromStream(arg0);
        return new StringBean(data);
    }

    @Override
    public void destroy() {
    }
}
