/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: TextCaser.java 70116 2013-02-19 18:18:49Z supol $
 */

package com.sun.ts.tests.websocket.common.client;

/**
 * Standard WebTestCase can search strings in an order case sensitive, case
 * insensitive or not in order case sensitive. When there is a need to match not
 * in order and case insensitive, this class is used.
 */
public enum TextCaser {
	UPPER, NONE, LOWER;

	/**
	 * Get the text upper cased, lower cased, or unchanged, depending on current
	 * TextCaser value
	 */
	public final String getCasedText(String text) {
		String ret = null;
		switch (this) {
		case UPPER:
			ret = text.toUpperCase();
			break;
		case LOWER:
			ret = text.toLowerCase();
			break;
		case NONE:
			ret = text;
			break;
		}
		return ret;
	}

}
