/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DenyAllServlet.java 52684 2007-02-12 04:30:10Z lschwenk $
 */

package com.sun.ts.tests.servlet.spec.security.annotations;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;
import javax.servlet.annotation.HttpConstraint;


/*
 * This is denying all
 */
@ServletSecurity(@HttpConstraint(EmptyRoleSemantic.DENY))
@WebServlet("/ServletDenyAll")
public class DenyAllServlet extends HttpServlet {


    //
    // this must be supported per Servlet 3.0 spec (section 13.4), bullet item 1.
    //
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();

        System.out.println("Inside  DenyAllServlet ....." + "<BR>");
        if ((request != null) && (request.getUserPrincipal() != null)) {
            System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            System.err.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            out.println("getRemoteUser(): " + request.getRemoteUser() + "<BR>");
        }

        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        if (request != null) {
            out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
            out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
            out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");
            out.println("isUserInRole(\"Administrator\"): !" + request.isUserInRole("Administrator") + "!<BR>");
        } else {
            out.println("DenyAllServlet.service() - request is null");
        }

    }


    public void doGet(HttpServletRequest request, HttpServletResponse response)
           throws ServletException, java.io.IOException {

        PrintWriter out = response.getWriter();

        if ((request != null) && (request.getUserPrincipal() != null)) {
            System.out.println("Inside  DenyAllServlet.doGet() ....." + "<BR>");
            System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            System.err.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
            out.println("getRemoteUser(): " + request.getRemoteUser() + "<BR>");
        } else {
            out.println("DenyAllServlet.doGet() - could not get request.getUserPrincipal()");
        }

        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        if (request != null) {
            out.println("isUserInRole(\"Administrator\"): !" + request.isUserInRole("Administrator") + "!<BR>");
            out.println("isUserInRole(\"Manager\"): !" + request.isUserInRole("Manager") + "!<BR>");
            out.println("isUserInRole(\"Employee\"): !" + request.isUserInRole("Employee") + "!<BR>");
        } else {
            out.println("DenyAllServlet.service() - request is null");
        }

    }

}

