/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.servlet.spec.multifiltermapping;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.FileNotFoundException;


public class TestServlet extends GenericTCKServlet {

    public void forwardTest(ServletRequest request,
            ServletResponse response) throws ServletException,
            IOException {
        String param = "parameter1";
        PrintWriter pw = response.getWriter();
        String path = request.getParameter(param);
        pw.println("path to access: " + path);
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);
        rd.forward(request, response);
    }

    public void includeTest(ServletRequest request,
            ServletResponse response) throws ServletException,
            IOException {
        String param = "parameter1";
        PrintWriter pw = response.getWriter();
        String path = request.getParameter(param);
        pw.println("path to access: " + path);
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);

       try {
            rd.include(request, response);
        } catch (IOException ex ) {
            pw.println("Resource " + path + " not available" );
            throw new FileNotFoundException("Resource " + path + " not available");
        }
    }
}