/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.async;

import javax.servlet.AsyncContext;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Servlet7 extends GenericServlet {
    private static final String filter_name = "Filter7";
    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = {ServletRequest.class,
        ServletResponse.class};

    public void service(ServletRequest request, ServletResponse response) throws
            ServletException, IOException {
        String test = (String) request.getParameter(TEST_HEADER);
        if (test == null) {
            test = (String) request.getAttribute(TEST_HEADER);
        }

        try {
            Method method = this.getClass().getMethod(test, TEST_ARGS);
            method.invoke(this, new Object[]{request, response});
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        } catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void direct(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println(filter_name + "=" + request.getAttribute(filter_name));
        pw.println("Servlet7_Async=" + request.isAsyncSupported());
    }

    public void startA(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println(filter_name + "=" + request.getAttribute(filter_name));
        pw.println("Servlet7_Async=" + request.isAsyncSupported());

        try {
            AsyncContext asyncc = request.startAsync();
            asyncc.complete();
            pw.println("Servlet7_Async=STARTED");
        } catch (IllegalStateException ilex) {
            pw.println("Servlet7_Async=NOT_STARTED");
        }
    }
}
