/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webfilter;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.annotation.WebFilter;


@WebFilter(dispatcherTypes = DispatcherType.REQUEST, urlPatterns={"/Servlet1"})
public final class TestFilter1 implements Filter {

    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {

        if (filterConfig == null) {
            StaticLog.add("FAILED_FILTER1_INVOKED");
        } else {
            StaticLog.add("FILTER1_INVOKED");
        }
        chain.doFilter(request, response);
    }

    // Remove the filter configuration object for this filter.
    public void destroy() {
    }

    //  initialize the filter configuration object for this filter.
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}
