/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.pluggability.api.javax_servlet.srevent;

import java.io.PrintWriter;
import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setServletName("TestServlet");
        setContextRoot("/servlet_plu_srevent_web");

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props:	 webServerHost;
     *				 webServerPort;
     *				 ts_home;
     */

    /* Run test */
    /*
     * @testName:  constructorTest
     * @assertion_ids: Servlet:JAVADOC:63
     * @test_Strategy: Servlet tries to get an instance of ServletRequestEvent.
     */
    public void constructorTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "constructorTest");
        invoke();
    }

    /*
     * @testName:  getServletContextTest
     * @assertion_ids: Servlet:JAVADOC:65
     * @test_Strategy:  Servlet calls constructor and tries to get the context
     *                    that was used in the constructor.
     */
    public void getServletContextTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "getServletContextTest");
        invoke();
    }

    /*
     * @testName:  getServletRequestTest
     * @assertion_ids: Servlet:JAVADOC:64
     * @test_Strategy:  Servlet calls constructor and tries to get the request
     *                    that was used in the constructor.
     */
    public void getServletRequestTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "getServletRequestTest");
        invoke();
    }
}
