/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.servletcontext305;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import com.sun.ts.tests.servlet.common.util.StaticLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TestServlet extends HttpTCKServlet {

    public void addListenerTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String name = "LISTENER_TEST";

        pw.println(name + "=" + getServletContext().getInitParameter(name).
                toUpperCase());
        getServletContext().removeAttribute(name);

        HttpSession hs = request.getSession();
        hs.setAttribute("attributeAddedTest", "Attribute1");
        hs.invalidate();

        ArrayList result = StaticLog.getClear();
        pw.println(result);
        ServletTestUtil.printResult(pw, true);
        getServletContext().removeAttribute("arraylist");
    }
}
