/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.sessiontrackingmode2;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.*;

public class TestServlet extends GenericTCKServlet {

    public void setSessionTrackingModes5(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        boolean passed = true;
        String expected_status = "Expected IllegalArgumentException thrown.";
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String status = (String) context.getAttribute("TCK_TEST_STATUS");
        if (!expected_status.equals(status)) {
            passed = false;
        }

        ServletTestUtil.printResult(pw.append(status), passed);
    }
}
