/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext30;


import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import java.util.ArrayList;

public final class AddSRListenerString
    implements ServletRequestListener {


    // Public Methods

    public void requestDestroyed(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("arraylist");
        if (al != null) {
            al.add("in requestDestroyed method of AddSRListenerString");
            event.getServletContext().setAttribute("arraylist", al);
        }
    }


    public void requestInitialized(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("arraylist");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("AddSRListenerString_INVOKED");
        event.getServletContext().setAttribute("arraylist", al);
    }

}
