/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */


package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext30;


import com.sun.ts.tests.servlet.common.util.StaticLog;

import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;

public final class AddSRAttributeListenerString
    implements ServletRequestAttributeListener {


    // Public Methods

    public void attributeAdded(ServletRequestAttributeEvent event) {
        StaticLog.add("SRAttributeAddedString:" + event.getName() + "," + event.getValue());

    }


    public void attributeRemoved(ServletRequestAttributeEvent event) {
        StaticLog.add("SRAttributeRemovedString:" + event.getName() + "," + event.getValue());
    }


    public void attributeReplaced(ServletRequestAttributeEvent event) {
        StaticLog.add("SRAttributeReplacedString:" + event.getName() + "," + event.getValue());
    }

}
