/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: GetNamedDispatcherTestServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext;


import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 *	Test for ServletContext.getNamedDispatcher(String) method
 */

public class GetNamedDispatcherTestServlet extends GenericServlet {

    /**
     *	We will try to get the RequestDispatcher for the servlet
     *	Registered as config
     */

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {

        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();

        String path = "GetNamedDispatcherTest";
        RequestDispatcher rd = context.getNamedDispatcher(path);

        if (rd != null) {
            passed = true;
        } else {
            passed = false;
        }
        ServletTestUtil.printResult(pw, passed);
    }
}
