/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.InterviewPropagator;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.CustomPropagationController;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.SortedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class InterviewParameters
extends Interview
implements Parameters {
    private TemplateManager templateManager = null;
    private boolean inGetName;
    private ExcludeListFilter cachedExcludeListFilter;
    private KeywordsFilter cachedKeywordsFilter;
    private StatusFilter cachedStatusFilter;
    private TestFilter cachedRelevantTestFilter;
    private TestSuite cachedRelevantTestFilterTestSuite;
    private TestEnvironment cachedRelevantTestFilterEnv;
    private TestFilter[] cachedTestFilters;
    private final String[] ignorableProps = new String[]{"INTERVIEW", "LOCALE", "TESTSUITE", "WORKDIR", "MARKERS", "IS_TEMPLATE", "TEMPLATE_PATH", "QUESTION"};
    private final String[] ignorablePrefs = new String[]{"MARKERS.", "EXTERNAL.", "TEMPLATE."};
    private BackupPolicy backupPolicy;
    private boolean markersEnabled;
    private boolean markersFilterEnabled;
    private File currFile;
    private boolean isTemplate;
    private String templatePath;
    private long currFileLastModified;
    private boolean currFileLoaded;
    protected File[] kflFiles;
    private CustomPropagationController pc = new CustomPropagationController();
    static final String TESTSUITE = "TESTSUITE";
    static final String WORKDIR = "WORKDIR";
    static final String NAME = "NAME";
    static final String DESC = "DESCRIPTION";
    static final String MARKERS_ENABLED = "MARKERS.enabled";
    static final String MARKERS_FILTER = "MARKERS.filter";
    static final String IS_TEMPLATE = "IS_TEMPLATE";
    static final String TEMPLATE_PATH = "TEMPLATE_PATH";
    static final String TRUE = "true";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(InterviewParameters.class);

    public void setPropagationController(CustomPropagationController pc) {
        this.pc = pc;
    }

    public CustomPropagationController getPropagationController() {
        return this.pc;
    }

    protected InterviewParameters(String tag) {
        super(tag);
    }

    @Override
    public abstract void setWorkDirectory(WorkDirectory var1);

    public void setTemplateManger(TemplateManager tm) {
        this.templateManager = tm;
    }

    public TemplateManager getTemplateManger() {
        return this.templateManager;
    }

    public void init(String[] args) throws Interview.Fault {
        if (args != null && args.length > 0) {
            throw new Interview.Fault(i18n, "ip.unknownArgs");
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getName() {
        if (this.inGetName) {
            return null;
        }
        try {
            TestEnvironment e;
            this.inGetName = true;
            Parameters.EnvParameters eParams = this.getEnvParameters();
            if (eParams != null && (e = eParams.getEnv()) != null) {
                String string = e.getName();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.inGetName = false;
        }
    }

    public String getDescription() {
        TestEnvironment e;
        Parameters.EnvParameters eParams = this.getEnvParameters();
        if (eParams != null && (e = eParams.getEnv()) != null) {
            return e.getDescription();
        }
        return null;
    }

    protected Question getPrologSuccessorQuestion() {
        return this.getEnvFirstQuestion();
    }

    @Override
    public TestEnvironment getEnv() {
        Parameters.EnvParameters eParams = this.getEnvParameters();
        if (eParams == null) {
            throw new NullPointerException();
        }
        return eParams.getEnv();
    }

    protected abstract Question getEnvFirstQuestion();

    protected Question getEnvSuccessorQuestion() {
        return this.getTestsFirstQuestion();
    }

    @Override
    public String[] getTests() {
        Parameters.TestsParameters iParams = this.getTestsParameters();
        return iParams == null ? null : iParams.getTests();
    }

    protected abstract Question getTestsFirstQuestion();

    protected Question getTestsSuccessorQuestion() {
        return this.getExcludeListFirstQuestion();
    }

    @Override
    public ExcludeList getExcludeList() {
        Parameters.ExcludeListParameters eParams = this.getExcludeListParameters();
        return eParams == null ? new ExcludeList() : eParams.getExcludeList();
    }

    public KnownFailuresList getKnownFailuresList() {
        try {
            if (this.kflFiles != null) {
                return new KnownFailuresList(this.getKnownFailureFiles());
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (KnownFailuresList.Fault f) {
            return null;
        }
    }

    public void setKnownFailureFiles(File[] files) {
        this.kflFiles = files;
    }

    public File[] getKnownFailureFiles() {
        return this.kflFiles;
    }

    protected abstract Question getExcludeListFirstQuestion();

    protected Question getExcludeTableFirstQuestion() {
        return this.getExcludeListFirstQuestion();
    }

    protected Question getExcludeListSuccessorQuestion() {
        return this.getKeywordsFirstQuestion();
    }

    protected Question getExcludeTableSuccessorQuestion() {
        return this.getExcludeListSuccessorQuestion();
    }

    @Override
    public Keywords getKeywords() {
        Parameters.KeywordsParameters kParams = this.getKeywordsParameters();
        return kParams == null ? null : kParams.getKeywords();
    }

    protected abstract Question getKeywordsFirstQuestion();

    protected Question getKeywordsSuccessorQuestion() {
        return this.getPriorStatusFirstQuestion();
    }

    @Override
    public boolean[] getPriorStatusValues() {
        Parameters.PriorStatusParameters sParams = this.getPriorStatusParameters();
        return sParams == null ? null : sParams.getPriorStatusValues();
    }

    protected abstract Question getPriorStatusFirstQuestion();

    protected Question getPriorStatusSuccessorQuestion() {
        return this.getConcurrencyFirstQuestion();
    }

    @Override
    public int getConcurrency() {
        Parameters.ConcurrencyParameters cParams = this.getConcurrencyParameters();
        return cParams == null ? 1 : cParams.getConcurrency();
    }

    protected abstract Question getConcurrencyFirstQuestion();

    protected Question getConcurrencySuccessorQuestion() {
        return this.getTimeoutFactorFirstQuestion();
    }

    @Override
    public float getTimeoutFactor() {
        Parameters.TimeoutFactorParameters tParams = this.getTimeoutFactorParameters();
        return tParams == null ? 1.0f : tParams.getTimeoutFactor();
    }

    protected abstract Question getTimeoutFactorFirstQuestion();

    protected Question getTimeoutFactorSuccessorQuestion() {
        return this.getEpilogFirstQuestion();
    }

    protected abstract Question getEpilogFirstQuestion();

    @Override
    public boolean isValid() {
        return this.isFinishable();
    }

    @Override
    public String getErrorMessage() {
        Question[] path = this.getPath();
        Question lastQuestion = path[path.length - 1];
        if (lastQuestion instanceof FinalQuestion) {
            return null;
        }
        if (lastQuestion instanceof ErrorQuestion) {
            return lastQuestion.getText();
        }
        String v = lastQuestion.getStringValue();
        return i18n.getString("ip.noAnswer", new Object[]{lastQuestion.getSummary(), lastQuestion.getText(), lastQuestion.getTag(), new Integer(v == null ? 0 : 1), this.trim(v)});
    }

    private String trim(String text) {
        return text == null ? null : (text.length() < 40 ? text : text.substring(0, 37) + "...");
    }

    public TestFilter getExcludeTableFilter() {
        return this.getExcludeListFilter();
    }

    @Override
    public TestFilter getExcludeListFilter() {
        ExcludeList t = this.getExcludeList();
        if (t == null) {
            this.cachedExcludeListFilter = null;
        } else if (this.cachedExcludeListFilter == null || this.cachedExcludeListFilter.getExcludeList() != t) {
            this.cachedExcludeListFilter = new ExcludeListFilter(t);
        }
        return this.cachedExcludeListFilter;
    }

    @Override
    public TestFilter getKeywordsFilter() {
        Keywords k = this.getKeywords();
        if (k == null) {
            this.cachedKeywordsFilter = null;
        } else if (this.cachedKeywordsFilter == null || this.cachedKeywordsFilter.getKeywords() != k) {
            this.cachedKeywordsFilter = new KeywordsFilter(k);
        }
        return this.cachedKeywordsFilter;
    }

    @Override
    public TestFilter getPriorStatusFilter() {
        WorkDirectory wd = this.getWorkDirectory();
        TestResultTable r = wd == null ? null : wd.getTestResultTable();
        boolean[] s = this.getPriorStatusValues();
        if (r == null || s == null) {
            this.cachedStatusFilter = null;
        } else if (this.cachedStatusFilter == null || this.cachedStatusFilter.getTestResultTable() != r || !InterviewParameters.equal(this.cachedStatusFilter.getStatusValues(), s)) {
            this.cachedStatusFilter = new StatusFilter(s, r);
        }
        return this.cachedStatusFilter;
    }

    @Override
    public TestFilter getRelevantTestFilter() {
        TestSuite ts = this.getTestSuite();
        TestEnvironment env = this.getEnv();
        if (ts == null || env == null) {
            this.cachedRelevantTestFilter = null;
        } else if (this.cachedRelevantTestFilter == null || ts != this.cachedRelevantTestFilterTestSuite || env != this.cachedRelevantTestFilterEnv) {
            this.cachedRelevantTestFilter = ts.createTestFilter(env);
        }
        return this.cachedRelevantTestFilter;
    }

    @Override
    public synchronized TestFilter[] getFilters() {
        TestFilter testSuiteFilter;
        TestFilter statusFilter;
        TestFilter keywordFilter;
        Vector<TestFilter> v = new Vector<TestFilter>();
        TestFilter excludeFilter = this.getExcludeListFilter();
        if (excludeFilter != null) {
            v.addElement(excludeFilter);
        }
        if ((keywordFilter = this.getKeywordsFilter()) != null) {
            v.addElement(keywordFilter);
        }
        if ((statusFilter = this.getPriorStatusFilter()) != null) {
            v.addElement(statusFilter);
        }
        if ((testSuiteFilter = this.getRelevantTestFilter()) != null) {
            v.addElement(testSuiteFilter);
        }
        if (v.size() == 0) {
            return null;
        }
        if (InterviewParameters.equal(v, this.cachedTestFilters)) {
            return this.cachedTestFilters;
        }
        Object[] filters = new TestFilter[v.size()];
        v.copyInto(filters);
        return filters;
    }

    private static boolean equal(boolean[] b1, boolean[] b2) {
        if (b1 == null || b2 == null) {
            return b1 == b2;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(Vector v, TestFilter[] f) {
        if (f == null || v.size() != f.length) {
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            if (v.elementAt(i).equals(f[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean tm) {
        this.isTemplate = tm;
        this.updatePath();
    }

    protected boolean isAutoUpdatableKey(String key) {
        return this.isAutoUpdatableKey(key, null);
    }

    protected boolean isAutoUpdatableKey(String key, String subkey) {
        return false;
    }

    protected boolean isUpdatableKey(String key) {
        return true;
    }

    public String getTemplatePath() {
        File f;
        if (this.isTemplate() && (f = this.getFile()) != null) {
            return f.getPath();
        }
        return this.templatePath;
    }

    public void setTemplatePath(String tu) {
        this.templatePath = tu;
    }

    public File getFile() {
        return this.currFile;
    }

    public void setFile(File f) {
        this.currFile = f;
        this.currFileLoaded = false;
        this.currFileLastModified = f != null ? f.lastModified() : 0L;
    }

    public static boolean isInterviewFile(File f) {
        return f.getName().endsWith(".jti");
    }

    public static InterviewParameters open(File file) throws IOException, Interview.Fault {
        return InterviewParameters.open(file, (TestSuite)null, (WorkDirectory)null);
    }

    public static InterviewParameters open(File file, TestSuite testSuite) throws IOException, Interview.Fault {
        if (testSuite == null) {
            throw new NullPointerException();
        }
        return InterviewParameters.open(file, testSuite, null);
    }

    public static InterviewParameters open(File file, WorkDirectory workDir) throws IOException, Interview.Fault {
        if (workDir == null) {
            throw new NullPointerException();
        }
        return InterviewParameters.open(file, workDir.getTestSuite(), workDir);
    }

    private static InterviewParameters open(File file, TestSuite testSuite, WorkDirectory workDir) throws IOException, Interview.Fault {
        InterviewParameters parameters;
        String s;
        Properties data = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            data.load(in);
        }
        catch (RuntimeException e) {
            throw new JTIFault((ResourceBundle)i18n, "ip.errorReadingFile", new Object[]{file, e});
        }
        finally {
            ((InputStream)in).close();
        }
        if (testSuite == null) {
            s = (String)data.get(TESTSUITE);
            if (s == null) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.noTestSuiteInFile", file);
            }
            try {
                testSuite = TestSuite.open(new File(s));
            }
            catch (FileNotFoundException e) {
                throw new TestSuiteFault((ResourceBundle)i18n, "ip.cantFindTestSuiteInFile", new Object[]{s, file});
            }
            catch (TestSuite.Fault e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuiteInFile", new Object[]{s, file, e.getMessage()});
            }
        }
        if (workDir == null && (s = (String)data.get(WORKDIR)) != null) {
            try {
                workDir = WorkDirectory.open(new File(s), testSuite);
            }
            catch (FileNotFoundException e) {
                throw new WorkDirFault((ResourceBundle)i18n, "ip.cantFindWorkDirInFile", new Object[]{s, file});
            }
            catch (WorkDirectory.Fault e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDirInFile", new Object[]{s, file, e.getMessage()});
            }
        }
        try {
            parameters = testSuite.createInterview();
        }
        catch (TestSuite.Fault e) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantCreateInterviewForTestSuite", new Object[]{testSuite.getPath(), e.getMessage()});
        }
        if (workDir != null) {
            parameters.setWorkDirectory(workDir);
        }
        try {
            parameters.load((Map)data, file);
        }
        catch (Interview.Fault e) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantLoadInterview", new Object[]{file, e.getMessage()});
        }
        return parameters;
    }

    @Override
    public void clear() {
        WorkDirectory wd = this.getWorkDirectory();
        super.clear();
        if (wd != null && TemplateUtilities.getTemplatePath(wd) != null && wd.getTestSuite() != null) {
            try {
                wd.getTestSuite().loadInterviewFromTemplate(TemplateUtilities.getTemplateFile(wd), this);
            }
            catch (TestSuite.Fault ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.setEdited(false);
        this.currFile = null;
    }

    public static InterviewParameters open(String testSuitePath, String workDirPath, String configFilePath) throws Interview.Fault {
        File ts = testSuitePath != null && testSuitePath.length() > 0 ? new File(testSuitePath) : null;
        File wd = workDirPath != null && workDirPath.length() > 0 ? new File(workDirPath) : null;
        File cf = configFilePath != null && configFilePath.length() > 0 ? new File(configFilePath) : null;
        return InterviewParameters.open(ts, wd, cf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InterviewParameters open(File testSuitePath, File workDirPath, File configFilePath) throws Interview.Fault {
        InterviewParameters config;
        WorkDirectory workDir;
        TestSuite testSuite;
        if (testSuitePath != null) {
            try {
                testSuite = TestSuite.open(testSuitePath);
            }
            catch (FileNotFoundException e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindTestSuite", testSuitePath);
            }
            catch (IOException e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuite", new Object[]{testSuitePath, e});
            }
            catch (TestSuite.Fault e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuite", new Object[]{testSuitePath, e.getMessage()});
            }
        } else {
            testSuite = null;
        }
        if (workDirPath != null) {
            try {
                if (testSuite == null) {
                    workDir = WorkDirectory.open(workDirPath);
                    testSuite = workDir.getTestSuite();
                }
                workDir = WorkDirectory.open(workDirPath, testSuite);
            }
            catch (FileNotFoundException e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindWorkDir", workDirPath);
            }
            catch (IOException e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDir", new Object[]{workDirPath, e});
            }
            catch (WorkDirectory.Fault e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDir", new Object[]{workDirPath, e.getMessage()});
            }
        } else {
            workDir = null;
        }
        if (configFilePath == null) {
            if (testSuite == null) throw new Interview.Fault(i18n, "ip.noPaths");
            try {
                config = testSuite.createInterview();
            }
            catch (TestSuite.Fault e) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantCreateInterviewForTestSuite", new Object[]{testSuitePath, e});
            }
            if (workDir == null) return config;
            config.setWorkDirectory(workDir);
            FileHistory h = FileHistory.getFileHistory(workDir, "configHistory.jtl");
            File latestConfigFile = h.getLatestEntry();
            if (latestConfigFile == null) return config;
            try {
                config.load(latestConfigFile);
                return config;
            }
            catch (IOException e) {}
            return config;
        }
        try {
            if (workDir != null) return InterviewParameters.open(configFilePath, workDir);
            if (testSuite == null) {
                config = InterviewParameters.open(configFilePath);
                testSuite = config.getTestSuite();
            } else {
                config = InterviewParameters.open(configFilePath, testSuite);
            }
            workDir = config.getWorkDirectory();
            return config;
        }
        catch (FileNotFoundException e) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindConfigFile", configFilePath);
        }
        catch (IOException e) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenConfigFile", new Object[]{configFilePath, e});
        }
    }

    public boolean load() throws IOException, Interview.Fault {
        File f = this.getFile();
        if (f != null && f.exists()) {
            return this.load(f);
        }
        this.clear();
        this.setEdited(false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(File file) throws FileNotFoundException, IOException, Interview.Fault {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties data = new Properties();
            data.load(in);
            boolean bl = this.load((Map)data, file);
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public boolean load(Map data, File file) throws Interview.Fault {
        this.load(data);
        String tm = (String)data.get(IS_TEMPLATE);
        this.setTemplate(tm != null && tm.equalsIgnoreCase(TRUE));
        this.setEdited(false);
        this.currFile = file;
        this.currFileLastModified = file.lastModified();
        this.currFileLoaded = true;
        return this.checkForUpdates();
    }

    public boolean checkForUpdates() {
        InterviewPropagator prop = new InterviewPropagator(this, this.ignorableProps, this.ignorablePrefs);
        return prop.checkForUpdate();
    }

    @Override
    public void load(Map data, boolean checkChecksum) throws Interview.Fault {
        super.load(data, checkChecksum);
        String me = (String)data.get(MARKERS_ENABLED);
        this.setMarkersEnabled(me != null && me.equalsIgnoreCase(TRUE));
        String mf = (String)data.get(MARKERS_FILTER);
        this.setMarkersFilterEnabled(mf != null && mf.equalsIgnoreCase(TRUE));
        String tm = (String)data.get(IS_TEMPLATE);
        this.setTemplate(tm != null && tm.equalsIgnoreCase(TRUE));
        String tu = null;
        tu = (String)data.get(TEMPLATE_PATH);
        this.setTemplatePath(tu);
    }

    public void load(Parameters other) {
        this.loadTestsParameters(other.getTestsParameters());
        this.loadExcludeListParameters(other.getExcludeListParameters());
        this.loadKeywordsParameters(other.getKeywordsParameters());
        this.loadPriorStatusParameters(other.getPriorStatusParameters());
        this.loadEnvParameters(other.getEnvParameters());
        this.loadConcurrencyParameters(other.getConcurrencyParameters());
        this.loadTimeoutFactorParameters(other.getTimeoutFactorParameters());
    }

    private void loadTestsParameters(Parameters.TestsParameters other) {
        Parameters.TestsParameters tp = this.getTestsParameters();
        if (!(tp instanceof Parameters.MutableTestsParameters)) {
            return;
        }
        Parameters.MutableTestsParameters mtp = (Parameters.MutableTestsParameters)tp;
        if (other instanceof Parameters.MutableTestsParameters) {
            Parameters.MutableTestsParameters mop = (Parameters.MutableTestsParameters)other;
            mtp.setTestsMode(mop.getTestsMode());
            mtp.setSpecifiedTests(mop.getSpecifiedTests());
        } else {
            String[] tests = other.getTests();
            if (tests == null) {
                mtp.setTestsMode(1);
                mtp.setSpecifiedTests(null);
            } else {
                mtp.setTestsMode(2);
                mtp.setSpecifiedTests(tests);
            }
        }
    }

    private void loadExcludeListParameters(Parameters.ExcludeListParameters other) {
        Parameters.ExcludeListParameters tp = this.getExcludeListParameters();
        if (!(tp instanceof Parameters.MutableExcludeListParameters)) {
            return;
        }
        Parameters.MutableExcludeListParameters mtp = (Parameters.MutableExcludeListParameters)tp;
        if (other instanceof Parameters.MutableExcludeListParameters) {
            Parameters.MutableExcludeListParameters mop = (Parameters.MutableExcludeListParameters)other;
            mtp.setExcludeMode(mop.getExcludeMode());
            mtp.setCustomExcludeFiles(mop.getCustomExcludeFiles());
            mtp.setLatestExcludeAutoCheckEnabled(mop.isLatestExcludeAutoCheckEnabled());
            mtp.setLatestExcludeAutoCheckMode(mop.getLatestExcludeAutoCheckMode());
            mtp.setLatestExcludeAutoCheckInterval(mop.getLatestExcludeAutoCheckInterval());
        } else {
            mtp.setExcludeMode(4);
            mtp.setCustomExcludeFiles(null);
            mtp.setLatestExcludeAutoCheckEnabled(false);
            mtp.setLatestExcludeAutoCheckMode(1);
            mtp.setLatestExcludeAutoCheckInterval(0);
        }
    }

    private void loadKeywordsParameters(Parameters.KeywordsParameters other) {
        Parameters.KeywordsParameters tp = this.getKeywordsParameters();
        if (!(tp instanceof Parameters.MutableKeywordsParameters)) {
            return;
        }
        Parameters.MutableKeywordsParameters mtp = (Parameters.MutableKeywordsParameters)tp;
        if (other instanceof Parameters.MutableKeywordsParameters) {
            Parameters.MutableKeywordsParameters mop = (Parameters.MutableKeywordsParameters)other;
            mtp.setKeywordsMode(mop.getKeywordsMode());
            mtp.setMatchKeywords(mop.getMatchKeywordsMode(), mop.getMatchKeywordsValue());
        } else {
            Keywords k = other.getKeywords();
            if (k == null) {
                mtp.setKeywordsMode(1);
                mtp.setMatchKeywords(3, "");
            } else {
                mtp.setKeywordsMode(2);
                mtp.setMatchKeywords(3, k.toString());
            }
        }
    }

    private void loadPriorStatusParameters(Parameters.PriorStatusParameters other) {
        Parameters.PriorStatusParameters tp = this.getPriorStatusParameters();
        if (!(tp instanceof Parameters.MutablePriorStatusParameters)) {
            return;
        }
        Parameters.MutablePriorStatusParameters mtp = (Parameters.MutablePriorStatusParameters)tp;
        if (other instanceof Parameters.MutablePriorStatusParameters) {
            Parameters.MutablePriorStatusParameters mop = (Parameters.MutablePriorStatusParameters)other;
            mtp.setPriorStatusMode(mop.getPriorStatusMode());
            mtp.setMatchPriorStatusValues(mop.getMatchPriorStatusValues());
        } else {
            boolean[] b = other.getPriorStatusValues();
            if (b == null) {
                mtp.setPriorStatusMode(1);
                mtp.setMatchPriorStatusValues(new boolean[4]);
            } else {
                mtp.setPriorStatusMode(2);
                mtp.setMatchPriorStatusValues(b);
            }
        }
    }

    private void loadEnvParameters(Parameters.EnvParameters other) {
        Parameters.EnvParameters tp = this.getEnvParameters();
        if (!(tp instanceof Parameters.LegacyEnvParameters)) {
            return;
        }
        Parameters.LegacyEnvParameters ltp = (Parameters.LegacyEnvParameters)tp;
        if (other instanceof Parameters.LegacyEnvParameters) {
            Parameters.LegacyEnvParameters lop = (Parameters.LegacyEnvParameters)other;
            ltp.setEnvFiles(lop.getEnvFiles());
            ltp.setEnvName(lop.getEnvName());
        }
    }

    private void loadConcurrencyParameters(Parameters.ConcurrencyParameters other) {
        Parameters.ConcurrencyParameters tp = this.getConcurrencyParameters();
        if (!(tp instanceof Parameters.MutableConcurrencyParameters)) {
            return;
        }
        Parameters.MutableConcurrencyParameters mtp = (Parameters.MutableConcurrencyParameters)tp;
        mtp.setConcurrency(other.getConcurrency());
    }

    private void loadTimeoutFactorParameters(Parameters.TimeoutFactorParameters other) {
        Parameters.TimeoutFactorParameters tp = this.getTimeoutFactorParameters();
        if (!(tp instanceof Parameters.MutableTimeoutFactorParameters)) {
            return;
        }
        Parameters.MutableTimeoutFactorParameters mtp = (Parameters.MutableTimeoutFactorParameters)tp;
        mtp.setTimeoutFactor(other.getTimeoutFactor());
    }

    public void save() throws IOException, Interview.Fault {
        File f = this.getFile();
        if (f == null) {
            throw new IllegalStateException();
        }
        this.save(f);
    }

    public void save(File file) throws IOException, Interview.Fault {
        this.save(file, false);
    }

    public void save(File file, boolean isTemplate) throws IOException, Interview.Fault {
        this.saveAs(file, true, true, isTemplate);
        this.setEdited(false);
        this.currFile = file;
        this.currFileLastModified = file.lastModified();
        this.currFileLoaded = true;
    }

    public void saveAs(File file) throws IOException, Interview.Fault {
        this.saveAs(file, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(File file, boolean saveTestSuite, boolean saveWorkDir, boolean isTemplate) throws IOException, Interview.Fault {
        TemplateManager tm;
        WorkDirectory wd;
        TestSuite ts;
        SortedProperties data = new SortedProperties();
        this.setTemplate(isTemplate);
        if (saveTestSuite && (ts = this.getTestSuite()) != null) {
            data.put(TESTSUITE, ts.getPath());
        }
        if (saveWorkDir && (wd = this.getWorkDirectory()) != null) {
            data.put(WORKDIR, wd.getPath());
        }
        this.save(data);
        if (this.isTemplate && (tm = this.templateManager) != null && !tm.canSaveTemplate(file)) {
            throw new Interview.Fault(i18n, "ip.badTmplPath");
        }
        OutputStream out = this.backupPolicy == null ? new BufferedOutputStream(new FileOutputStream(file)) : this.backupPolicy.backupAndOpenStream(file);
        try {
            data.store(out, "JavaTest Harness Configuration Interview");
        }
        finally {
            out.close();
        }
    }

    public void saveAs(File file, boolean saveTestSuite, boolean saveWorkDir) throws IOException, Interview.Fault {
        this.saveAs(file, saveTestSuite, saveWorkDir, false);
    }

    @Override
    public void save(Map data) {
        String desc;
        if (this.markersEnabled) {
            data.put(MARKERS_ENABLED, TRUE);
        }
        if (this.markersFilterEnabled) {
            data.put(MARKERS_FILTER, TRUE);
        }
        if (this.isTemplate()) {
            data.put(IS_TEMPLATE, TRUE);
            this.storeTemplateProperties(new Properties());
        } else {
            WorkDirectory wd = this.getWorkDirectory();
            if (wd != null && TemplateUtilities.getTemplatePath(wd) != null) {
                data.put(TEMPLATE_PATH, TemplateUtilities.getTemplatePath(wd));
            }
        }
        String name = this.getName();
        if (name != null) {
            data.put(NAME, name);
        }
        if ((desc = this.getDescription()) != null) {
            data.put(DESC, desc);
        }
        super.save(data);
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public boolean isFileLoaded() {
        return this.currFileLoaded;
    }

    public boolean isFileNewer() {
        File f = this.getFile();
        return f != null && f.exists() && (this.currFileLastModified == 0L || f.lastModified() > this.currFileLastModified);
    }

    public boolean getMarkersEnabled() {
        return this.markersEnabled;
    }

    public void setMarkersEnabled(boolean on) {
        if (on != this.markersEnabled) {
            this.markersEnabled = on;
            this.setEdited(true);
        }
    }

    public boolean getMarkersFilterEnabled() {
        return this.markersFilterEnabled;
    }

    public void setMarkersFilterEnabled(boolean on) {
        if (on != this.markersFilterEnabled) {
            this.markersFilterEnabled = on;
            this.setEdited(true);
        }
    }

    public static interface TemplateManager {
        public boolean canSaveTemplate(File var1);
    }

    public static class JTIFault
    extends Interview.Fault {
        public JTIFault(ResourceBundle i18n, String s) {
            super(i18n, s);
        }

        public JTIFault(ResourceBundle i18n, String s, Object o) {
            super(i18n, s, o);
        }

        public JTIFault(ResourceBundle i18n, String s, Object[] o) {
            super(i18n, s, o);
        }
    }

    public static class TestSuiteFault
    extends Interview.Fault {
        public TestSuiteFault(ResourceBundle i18n, String s) {
            super(i18n, s);
        }

        public TestSuiteFault(ResourceBundle i18n, String s, Object o) {
            super(i18n, s, o);
        }

        public TestSuiteFault(ResourceBundle i18n, String s, Object[] o) {
            super(i18n, s, o);
        }
    }

    public static class WorkDirFault
    extends Interview.Fault {
        public WorkDirFault(ResourceBundle i18n, String s) {
            super(i18n, s);
        }

        public WorkDirFault(ResourceBundle i18n, String s, Object o) {
            super(i18n, s, o);
        }

        public WorkDirFault(ResourceBundle i18n, String s, Object[] o) {
            super(i18n, s, o);
        }
    }
}

