/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.idstore.database.multi;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.annotation.security.DeclareRoles;
import javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import com.sun.ts.tests.securityapi.idstore.common.PlaintextPasswordHash;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.annotation.sql.DataSourceDefinition;


/**
 * The datasource defined in *_web.xml
 */
@DatabaseIdentityStoreDefinition(	    
		dataSourceLookup="jdbc/securityAPIDB",
	    callerQuery="select password from caller where name = ?",
	    groupsQuery="select group_name from caller_groups where caller_name = ?",
	    priority=200,
	    hashAlgorithm = PlaintextPasswordHash.class
)

@LdapIdentityStoreDefinition(
	    url = "ldap://localhost:11389/",
	    callerBaseDn = "ou=callerx,dc=securityapi,dc=net",
	    groupSearchBase = "ou=groupx,dc=securityapi,dc=net",
		groupSearchFilter = "(&(member=%s)(objectClass=groupOfNames))",
        priority=100
)

/**
 * Test Servlet that prints out the name of the authenticated caller and whether
 * this caller is in any of the roles {Administrator, Manager, Employee}
 *
 */
@DeclareRoles({"Administrator", "Manager", "Employee"})
@WebServlet("/ServletForDatabaseIDStore")
public class ServletForDatabaseIDStore extends HttpServlet {   
   

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	 System.out.println("Inside ServletForDatabaseIDStore:doGet() ....." + "<BR>");
     	
     	
         String webName = null;
         if (request.getUserPrincipal() != null) {
         	System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");             
             webName = request.getUserPrincipal().getName();
         }

         response.getWriter().write("web username: " + webName + "\n");  
    }

}
