/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.idstore.customhandler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.annotation.security.DeclareRoles;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Test Servlet that prints out the name of the authenticated caller and whether
 * this caller is in any of the roles {Administrator, Manager, Employee}
 *
 */

@LdapIdentityStoreDefinition(
	    url = "ldap://localhost:11389/",
	    callerBaseDn = "ou=caller,dc=securityapi,dc=net",
	    callerSearchBase = "ou=caller,dc=securityapi,dc=net",
	    callerSearchFilter = "(&(uid=%s)(objectClass=person))",
	    groupSearchBase  = "ou=group,dc=securityapi,dc=net",
		groupSearchFilter = "(&(member=%s)(objectClass=groupOfNames))",
	    groupSearchScope = LdapSearchScope.ONE_LEVEL,
	    priority=200
	)


@DeclareRoles({"Administrator", "Manager", "Employee"})
@WebServlet("/ServletForIDStoreCustomhandler")
public class ServletForIDStoreCustomhandler extends HttpServlet {   
   

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	 System.out.println("Inside  ServletForIDStoreCustomhandler:doGet() ....." + "<BR>");
     	
     	
         String webName = null;
         if (request.getUserPrincipal() != null) {
         	System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");             
             webName = request.getUserPrincipal().getName();
         }

         response.getWriter().write("web username: " + webName + "\n");  
    }

}
