/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTextInput
extends HtmlInput {
    private static final long serialVersionUID = -2473799124286935674L;
    private boolean preventDefault_;
    private int selectionStart_;
    private int selectionEnd_;

    HtmlTextInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this.isDisabled()) {
            return this.getPage();
        }
        this.preventDefault_ = false;
        return super.type(c, shiftKey, ctrlKey, altKey);
    }

    @Override
    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        if (this.preventDefault_) {
            return;
        }
        String value = this.getValueAttribute();
        if (c == '\b') {
            if (value.length() > 0) {
                this.setValueAttribute(value.substring(0, value.length() - 1));
            }
        } else if (c == ' ' || !Character.isWhitespace(c)) {
            this.setValueAttribute(value + c);
        }
    }

    @Override
    protected void preventDefault() {
        this.preventDefault_ = true;
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    public String getSelectedText() {
        String text = null;
        if (this.selectionStart_ != this.selectionEnd_) {
            text = this.getValueAttribute().substring(this.selectionStart_, this.selectionEnd_);
        }
        return text;
    }

    public int getSelectionStart() {
        return this.selectionStart_;
    }

    public void setSelectionStart(int selectionStart) {
        int length;
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionStart > (length = this.getValueAttribute().length())) {
            selectionStart = length;
        }
        if (this.selectionEnd_ < selectionStart) {
            this.selectionEnd_ = selectionStart;
        }
        this.selectionStart_ = selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd_;
    }

    public void setSelectionEnd(int selectionEnd) {
        int length;
        if (selectionEnd < 0) {
            selectionEnd = 0;
        }
        if (selectionEnd > (length = this.getValueAttribute().length())) {
            selectionEnd = length;
        }
        if (selectionEnd < this.selectionStart_) {
            this.selectionStart_ = selectionEnd;
        }
        this.selectionEnd_ = selectionEnd;
    }

    @Override
    public void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue, boolean cloning) {
        super.setAttributeValue(namespaceURI, qualifiedName, attributeValue, cloning);
        if (qualifiedName.equals("value") && !cloning) {
            this.setSelectionStart(attributeValue.length());
            this.setSelectionEnd(attributeValue.length());
        }
    }

    public void select() {
        this.focus();
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getValueAttribute().length());
    }
}

