/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.LastRunFilter;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.report.COFReport;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.PlainTextReport;
import com.sun.javatest.report.ReportModel;
import com.sun.javatest.report.XMLReport;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.BackupUtil;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Report
implements ReportModel {
    private InterviewParameters params;
    private TestFilter[] paramFilters;
    private static final String PREFS_GEN_HTML = "rpt.type.html";
    private static final String PREFS_GEN_PLAIN = "rpt.type.plain";
    private static final String PREFS_GEN_XML = "rpt.type.xml";
    private static final String PREFS_GEN_COF = "rpt.type.cof";
    private static final String PREFS_COF_TC = "rpt.cof.tc";
    private static final String PREFS_HTML_CONFIG = "rpt.html.config";
    private static final String PREFS_HTML_QL = "rpt.html.ql";
    private static final String PREFS_HTML_ENV = "rpt.html.env";
    private static final String PREFS_HTML_STD = "rpt.html.std";
    private static final String PREFS_HTML_RES = "rpt.html.res";
    private static final String PREFS_HTML_KWS = "rpt.html.kws";
    private static final String PREFS_HTML_KFL = "rps.html.kfl";
    private static final String PREFS_HTML_REPORTF = "rpt.html.reportf";
    private static final String PREFS_HTML_INDEXF = "rpt.html.htmlf";
    private static final String PREFS_HTML_STATEF = "rpt.html.statef";
    private static final String PREFS_HTML_KFLF2E = "rps.html.kflf2e";
    private static final String PREFS_HTML_KFLF2F = "rpt.html.kflf2f";
    private static final String PREFS_HTML_KFLMISSING = "rpt.html.kflmissing";
    private static final String PREFS_HTML_KFLTC = "rpt.html.kfltc";
    private static final String PREFS_BACK = "rpt.bak.enable";
    private static final String PREFS_BACK_NUM = "rpt.bak.num";
    private File reportDir;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Report.class);
    public static final String MARKER_FILE_NAME = "reportdir.dat";
    public static final String INDEX_FILE_NAME = "index.html";
    private ArrayList startGenListeners;

    public Report() {
    }

    public Report(InterviewParameters params, File dir) {
        this.params = params;
        this.reportDir = dir.getAbsoluteFile();
    }

    public Report(InterviewParameters params, File dir, TestFilter tf) {
        this(params, dir);
        this.paramFilters = new TestFilter[]{tf};
    }

    public File[] checkExistingFiles() {
        Vector<File> v = new Vector<File>();
        String[] files = HTMLReport.getFilenamesUsed();
        String[] list = this.reportDir.list();
        for (int i = 0; i < files.length; ++i) {
            for (int j = 0; j < list.length; ++j) {
                if (!files[i].equals(list[j])) continue;
                v.addElement(new File(this.reportDir, list[j]));
            }
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] result = new File[v.size()];
        v.copyInto(result);
        return result;
    }

    public void writeReport(Settings s, File dir) throws IOException {
        this.writeReports(s, dir, Collections.EMPTY_LIST);
    }

    public void writeReports(Settings s, File dir, Collection customReports) throws IOException {
        this.reportDir = dir.getAbsoluteFile();
        s.ip.getWorkDirectory().getTestResultTable().waitUntilReady();
        this.backupReports(this.reportDir, s);
        try {
            if (s.isHtmlEnabled()) {
                this.writeReportHTML(s);
            }
        }
        catch (RuntimeException t) {
            t.printStackTrace();
            throw t;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (s.isPlainEnabled()) {
            this.writeSummaryTXT(s);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (s.isCOFEnabled()) {
            this.writeReportCOF(s);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        CustomReport.ReportEnviroment re = new CustomReport.ReportEnviroment(s);
        if (s.isXmlEnabled()) {
            this.notifyStartGenListeners(s, "xml");
            this.writeReportXML(re);
        }
        if (Thread.currentThread().isInterrupted()) {
            re.cleanup();
            return;
        }
        Report.writePrefs(s);
        if (Thread.currentThread().isInterrupted()) {
            re.cleanup();
            return;
        }
        Iterator it = customReports.iterator();
        HashMap<File, CustomReport> crMap = new HashMap<File, CustomReport>();
        while (it.hasNext()) {
            CustomReport cr = (CustomReport)it.next();
            cr.setEnviroment(re);
            this.notifyStartGenListeners(s, cr.getName());
            File f = cr.createReport(new File(this.reportDir, cr.getReportId()));
            if (f != null) {
                crMap.put(f, cr);
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            re.cleanup();
            return;
        }
        re.cleanup();
        this.updateStaffFiles(this.reportDir, s, crMap);
    }

    public void writeReport() throws IOException {
        Settings settings = Report.getSettingsPrefs();
        settings.ip = this.params;
        if (this.paramFilters != null) {
            settings.filter = this.paramFilters.length == 1 ? this.paramFilters[0] : new CompositeFilter(this.paramFilters);
        }
        this.params.getWorkDirectory().getTestResultTable().waitUntilReady();
        this.backupReports(this.reportDir, settings);
        this.writeReportHTML(settings);
        this.writeSummaryTXT(settings);
        this.updateStaffFiles(this.reportDir, settings, null);
    }

    public void writeReport(String type) throws IOException {
        Settings settings = Report.getSettingsPrefs();
        settings.ip = this.params;
        if (this.paramFilters != null) {
            settings.filter = this.paramFilters.length == 1 ? this.paramFilters[0] : new CompositeFilter(this.paramFilters);
        }
        this.params.getWorkDirectory().getTestResultTable().waitUntilReady();
        this.backupReports(this.reportDir, settings);
        if (type.equalsIgnoreCase("html")) {
            this.writeReportHTML(settings);
        } else if (type.equalsIgnoreCase("txt")) {
            this.writeSummaryTXT(settings);
        } else if (type.equalsIgnoreCase("cof")) {
            this.writeReportCOF(settings);
        } else if (type.equalsIgnoreCase("xml")) {
            CustomReport.ReportEnviroment re = new CustomReport.ReportEnviroment(settings);
            this.notifyStartGenListeners(settings, "xml");
            this.writeReportXML(re);
        } else {
            String cls = null;
            TestSuite testSuite = this.params.getTestSuite();
            cls = testSuite.getTestSuiteInfo("tmcontext");
            CustomReportManager cm = null;
            try {
                cm = cls == null ? (CustomReportManager)Class.forName("com.sun.javatest.exec.ContextManager").newInstance() : (CustomReportManager)Class.forName(cls, true, testSuite.getClassLoader()).newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
            CustomReport[] customReports = cm.getCustomReports();
            if (customReports == null || customReports.length == 0) {
                throw new IllegalStateException("Unknown report type: " + type);
            }
            boolean result = false;
            HashMap<File, CustomReport> crMap = new HashMap<File, CustomReport>();
            for (int i = 0; i < customReports.length; ++i) {
                if (!customReports[i].getReportId().equalsIgnoreCase(type)) continue;
                try {
                    CustomReport.ReportEnviroment re = new CustomReport.ReportEnviroment(this.params, settings.filter);
                    customReports[i].setEnviroment(re);
                    this.notifyStartGenListeners(settings, customReports[i].getName());
                    File f = customReports[i].createReport(null, this.reportDir, this.params, settings.filter);
                    if (f != null) {
                        crMap.put(f, customReports[i]);
                    }
                    result = true;
                    break;
                }
                catch (CustomReport.ReportException e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (!result) {
                throw new IllegalStateException("Unknown report type: " + type);
            }
            this.updateStaffFiles(this.reportDir, settings, crMap);
            return;
        }
        this.updateStaffFiles(this.reportDir, settings, null);
    }

    public static boolean isReportDirectory(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(MARKER_FILE_NAME)) continue;
            return true;
        }
        return Report.isLegacyReportDirectory(d);
    }

    static boolean isLegacyReportDirectory(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        String[] htmlNames = HTMLReport.getFilenamesUsed();
        String[] textNames = PlainTextReport.getFilenamesUsed();
        for (int i = 0; i < list.length; ++i) {
            int j;
            for (j = 0; j < htmlNames.length; ++j) {
                if (htmlNames[j].equals(INDEX_FILE_NAME) || !list[i].equals(htmlNames[j])) continue;
                return true;
            }
            for (j = 0; j < textNames.length; ++j) {
                if (!list[i].equals(textNames[j])) continue;
                return true;
            }
        }
        return false;
    }

    private void backupReports(File dir, Settings s) {
        if (s.isBackupsEnabled()) {
            BackupUtil.backupAllSubdirs(dir, s.backups);
            this.backupIndexFile(dir, s.backups);
        }
    }

    private void backupIndexFile(File dir, int maxBackups) {
        int nbackups = BackupUtil.backupFile(new File(dir, INDEX_FILE_NAME), maxBackups);
        for (int i = 1; i <= nbackups; ++i) {
            this.updateIndexLinks(new File(dir, "index.html~" + Integer.toString(i) + "~"), i);
        }
    }

    private void updateIndexLinks(File index, int backupNumb) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(index)));
            while ((line = r.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String oldId = backupNumb == 1 ? "" : "~" + (backupNumb - 1) + "~";
        String newId = "~" + backupNumb + "~";
        File reportDir = index.getParentFile();
        File[] files = reportDir.listFiles();
        ArrayList<File> subdirs = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory() || files[i].getName().lastIndexOf(newId) == -1) continue;
            subdirs.add(files[i]);
        }
        LinkFinder finder = new LinkFinder(index);
        Vector links = finder.getLinks();
        block6: for (int i = 0; i < links.size(); ++i) {
            String link = (String)links.get(i);
            for (int j = 0; j < subdirs.size(); ++j) {
                String newName = ((File)subdirs.get(j)).getName();
                String oldName = newName.replaceAll(newId, oldId);
                if (link.lastIndexOf(oldName) == -1) continue;
                StringBuilder newLink = new StringBuilder(link);
                int link_start = newLink.indexOf(oldName);
                newLink.replace(link_start, link_start + oldName.length(), newName);
                int start = sb.indexOf(link);
                sb.replace(start, start + link.length(), newLink.toString());
                continue block6;
            }
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(index));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void updateStaffFiles(File dir, Settings s, HashMap crs) {
        this.updateMarkerFile(dir);
        this.updateIndexFile(dir, s, crs);
    }

    private void updateMarkerFile(File dir) {
        File f = new File(dir, MARKER_FILE_NAME);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    private void updateIndexFile(File dir, Settings s, HashMap crs) {
        File f = new File(dir, INDEX_FILE_NAME);
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
            this.fillIndexFile(f, s, crs);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void fillIndexFile(File index, Settings s, HashMap crs) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(index));
            HTMLWriter out = new HTMLWriter(writer);
            out.setI18NResourceBundle(i18n);
            out.startTag("html");
            out.startTag("head");
            out.startTag("title");
            out.writeI18N("index.title");
            out.endTag("title");
            out.endTag("head");
            out.startTag("body");
            out.startTag("h1");
            out.write(s.ip.getTestSuite().getName());
            out.endTag("h1");
            out.newLine();
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat(i18n.getString("index.dateFormat"));
            out.write(i18n.getString("index.date.txt", format.format(date)));
            out.newLine();
            File f = s.indexHtml ? new File("html" + File.separator + INDEX_FILE_NAME) : (s.reportHtml ? new File("html" + File.separator + "report.html") : new File("html" + File.separator));
            File absolute = new File(this.reportDir, f.getPath());
            if (absolute.exists()) {
                out.startTag("p");
                out.writeLink(f, i18n.getString("index.htmltype.txt"));
                out.startTag("br");
                out.writeI18N("index.desc.html");
            }
            if ((absolute = new File(this.reportDir, (f = new File("text" + File.separator + "summary.txt")).getPath())).exists()) {
                out.startTag("p");
                out.writeLink(f, i18n.getString("index.plaintype.txt"));
                out.startTag("br");
                out.writeI18N("index.desc.txt");
            }
            if ((absolute = new File(this.reportDir, (f = new File("xml" + File.separator + "report.xml")).getPath())).exists()) {
                out.startTag("p");
                out.writeLink(f, i18n.getString("index.xmltype.txt"));
                out.startTag("br");
                out.writeI18N("index.desc.xml");
            }
            if ((absolute = new File(this.reportDir, (f = new File("cof" + File.separator + "cof.xml")).getPath())).exists()) {
                out.startTag("p");
                out.writeLink(f, i18n.getString("index.coftype.txt"));
                out.startTag("br");
                out.writeI18N("index.desc.cof");
            }
            if (crs != null) {
                Set keys = crs.keySet();
                for (File indexFile : keys) {
                    CustomReport cr = (CustomReport)crs.get(indexFile);
                    if (!indexFile.isAbsolute()) {
                        indexFile = new File(cr.getReportId() + File.separator + indexFile.getPath());
                    } else {
                        String absPath = indexFile.getAbsolutePath();
                        String relPath = absPath.substring(this.reportDir.getAbsolutePath().length() + 1);
                        indexFile = new File(relPath);
                    }
                    out.startTag("p");
                    out.writeLink(indexFile, cr.getName());
                    out.startTag("br");
                    out.write(cr.getDescription());
                }
            }
            out.endTag("body");
            out.endTag("html");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public File getReportDir() {
        return this.reportDir;
    }

    public static String[] getHtmlReportFilenames() {
        return HTMLReport.getReportFilenames();
    }

    public static String[] getPlainReportFilenames() {
        return PlainTextReport.getReportFilenames();
    }

    public static String[] getFilenamesUsed() {
        int i;
        String[] htmlNames = HTMLReport.getFilenamesUsed();
        String[] plainTextNames = PlainTextReport.getFilenamesUsed();
        String[] xmlNames = XMLReport.getFilenamesUsed();
        String[] filenames = new String[htmlNames.length + plainTextNames.length + xmlNames.length];
        for (i = 0; i < htmlNames.length; ++i) {
            filenames[i] = "html/" + htmlNames[i];
        }
        for (i = htmlNames.length; i < plainTextNames.length; ++i) {
            filenames[i] = "text/" + plainTextNames[i];
        }
        for (i = plainTextNames.length; i < xmlNames.length; ++i) {
            filenames[i] = "xml/" + plainTextNames[i];
        }
        return filenames;
    }

    private void writeReportHTML(Settings settings) throws IOException {
        HTMLReport rpt = new HTMLReport(i18n);
        File out = new File(this.reportDir, "html");
        out.mkdir();
        this.notifyStartGenListeners(settings, "html");
        rpt.write(settings, out);
    }

    private void writeReportXML(CustomReport.ReportEnviroment settings) throws IOException {
        XMLReport rpt = new XMLReport();
        File out = new File(this.reportDir, "xml");
        out.mkdir();
        rpt.write(settings, out);
    }

    private void writeSummaryTXT(Settings settings) throws IOException {
        PlainTextReport rpt = new PlainTextReport(i18n);
        File out = new File(this.reportDir, "text");
        out.mkdir();
        this.notifyStartGenListeners(settings, "pt");
        rpt.write(settings, out);
    }

    private void writeReportCOF(Settings settings) throws IOException {
        COFReport cof = new COFReport();
        File out = new File(this.reportDir, "cof");
        out.mkdir();
        this.notifyStartGenListeners(settings, "cof");
        cof.write(settings, out);
    }

    private void notifyStartGenListeners(Settings s, String reportID) {
        if (this.startGenListeners != null) {
            for (int i = 0; i < this.startGenListeners.size(); ++i) {
                StartGenListener sgl = (StartGenListener)this.startGenListeners.get(i);
                sgl.startReportGeneration(s, reportID);
            }
        }
    }

    public static void writePrefs(Settings s) {
        Preferences prefs = Preferences.access();
        s.write(prefs);
    }

    public static Settings getSettingsPrefs() {
        Preferences prefs = Preferences.access();
        return Settings.create(prefs);
    }

    public void addStartGenListener(StartGenListener l) {
        if (this.startGenListeners == null) {
            this.startGenListeners = new ArrayList();
        }
        this.startGenListeners.add(l);
    }

    public void removeStartGeneratingListener(StartGenListener l) {
        if (this.startGenListeners != null) {
            this.startGenListeners.remove(l);
        }
    }

    public static interface StartGenListener {
        public void startReportGeneration(Settings var1, String var2);
    }

    public static interface CustomReportManager {
        public CustomReport[] getCustomReports();
    }

    public static class Settings {
        InterviewParameters ip;
        TestFilter filter;
        boolean genHtml = true;
        boolean genPlain = true;
        boolean genCof = false;
        boolean genXml = false;
        private boolean genCofTestCases = true;
        boolean genConfig = true;
        boolean genQl = true;
        boolean genEnv = true;
        boolean genStd = true;
        boolean genResults = true;
        boolean genKfl = true;
        boolean genKws = true;
        boolean kflMissing = true;
        boolean kflF2e = true;
        boolean kflF2f = true;
        boolean kflTestCases = true;
        boolean reportHtml = true;
        boolean indexHtml = false;
        boolean[] stateFiles = new boolean[4];
        boolean doBackups = true;
        int backups = 1;

        public Settings() {
            for (int i = 0; i < this.stateFiles.length; ++i) {
                this.stateFiles[i] = true;
            }
        }

        public Settings(InterviewParameters p) {
            this();
            this.ip = p;
        }

        public void write(Preferences prefs) {
            prefs.setPreference(Report.PREFS_GEN_HTML, Boolean.toString(this.genHtml));
            prefs.setPreference(Report.PREFS_GEN_PLAIN, Boolean.toString(this.genPlain));
            prefs.setPreference(Report.PREFS_GEN_XML, Boolean.toString(this.genXml));
            prefs.setPreference(Report.PREFS_GEN_COF, Boolean.toString(this.genCof));
            prefs.setPreference(Report.PREFS_COF_TC, Boolean.toString(this.genCofTestCases));
            prefs.setPreference(Report.PREFS_HTML_CONFIG, Boolean.toString(this.genConfig));
            prefs.setPreference(Report.PREFS_HTML_QL, Boolean.toString(this.genQl));
            prefs.setPreference(Report.PREFS_HTML_ENV, Boolean.toString(this.genEnv));
            prefs.setPreference(Report.PREFS_HTML_STD, Boolean.toString(this.genStd));
            prefs.setPreference(Report.PREFS_HTML_RES, Boolean.toString(this.genResults));
            prefs.setPreference(Report.PREFS_HTML_KFL, Boolean.toString(this.genKfl));
            prefs.setPreference(Report.PREFS_HTML_KWS, Boolean.toString(this.genKws));
            prefs.setPreference(Report.PREFS_HTML_REPORTF, Boolean.toString(this.reportHtml));
            prefs.setPreference(Report.PREFS_HTML_INDEXF, Boolean.toString(this.indexHtml));
            prefs.setPreference(Report.PREFS_HTML_KFLF2E, Boolean.toString(this.kflF2e));
            prefs.setPreference(Report.PREFS_HTML_KFLF2F, Boolean.toString(this.kflF2f));
            prefs.setPreference(Report.PREFS_HTML_KFLMISSING, Boolean.toString(this.kflMissing));
            prefs.setPreference(Report.PREFS_HTML_KFLTC, Boolean.toString(this.kflTestCases));
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.stateFiles.length; ++i) {
                sb.append(Boolean.toString(this.stateFiles[i]));
                if (i + 1 >= this.stateFiles.length) continue;
                sb.append(",");
            }
            prefs.setPreference(Report.PREFS_HTML_STATEF, sb.toString());
            prefs.setPreference(Report.PREFS_BACK, Boolean.toString(this.doBackups));
            prefs.setPreference(Report.PREFS_BACK_NUM, Integer.toString(this.backups));
        }

        public static Settings create(Preferences prefs) {
            Settings result = new Settings();
            String tst = prefs.getPreference(Report.PREFS_GEN_HTML);
            if (tst == null) {
                return result;
            }
            result.genHtml = Settings.parseBoolean(tst);
            result.genPlain = Settings.parseBoolean(prefs.getPreference(Report.PREFS_GEN_PLAIN));
            result.genXml = Settings.parseBoolean(prefs.getPreference(Report.PREFS_GEN_XML));
            result.genCof = Settings.parseBoolean(prefs.getPreference(Report.PREFS_GEN_COF));
            result.genCofTestCases = Settings.parseBoolean(prefs.getPreference(Report.PREFS_COF_TC));
            result.genConfig = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_CONFIG));
            result.genQl = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_QL));
            result.genEnv = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_ENV));
            result.genStd = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_STD));
            result.genResults = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_RES));
            result.genKfl = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_KFL));
            result.genKws = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_KWS));
            result.reportHtml = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_REPORTF));
            result.indexHtml = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_INDEXF));
            result.kflF2e = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_KFLF2E));
            result.kflF2f = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_KFLF2F));
            result.kflMissing = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_KFLMISSING));
            result.kflTestCases = Settings.parseBoolean(prefs.getPreference(Report.PREFS_HTML_KFLTC));
            String[] states = StringArray.splitList(prefs.getPreference(Report.PREFS_HTML_STATEF), ",");
            if (states != null) {
                for (int i = 0; i < states.length; ++i) {
                    result.stateFiles[i] = Settings.parseBoolean(states[i]);
                }
            }
            result.doBackups = Settings.parseBoolean(prefs.getPreference(Report.PREFS_BACK));
            try {
                result.backups = Integer.parseInt(prefs.getPreference(Report.PREFS_BACK_NUM));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return result;
        }

        public void setInterview(InterviewParameters p) {
            this.ip = p;
        }

        public void setFilter(TestFilter f) {
            this.filter = f;
        }

        public void setEnableHtmlReport(boolean state) {
            this.genHtml = state;
        }

        public void setEnableXmlReport(boolean state) {
            this.genXml = state;
        }

        public void setEnablePlainReport(boolean state) {
            this.genPlain = state;
        }

        public void setEnableCOFReport(boolean state) {
            this.genCof = state;
        }

        public void setUseTestCases(boolean state) {
            this.genCofTestCases = state;
        }

        public void setShowConfigSection(boolean state) {
            this.genConfig = state;
        }

        public void setShowQuestionLog(boolean state) {
            this.genQl = state;
        }

        public void setShowEnvLog(boolean state) {
            this.genEnv = state;
        }

        public void setShowStdValues(boolean state) {
            this.genStd = state;
        }

        public void setShowResults(boolean state) {
            this.genResults = state;
        }

        public void setShowKflReport(boolean state) {
            this.genKfl = state;
        }

        public void setShowKeywordSummary(boolean state) {
            this.genKws = state;
        }

        public void setEnableHtmlStateFile(int status, boolean state) {
            if (status >= this.stateFiles.length) {
                return;
            }
            this.stateFiles[status] = state;
        }

        public void setHtmlMainReport(boolean reporthtml, boolean indexhtml) {
            this.reportHtml = reporthtml;
            this.indexHtml = indexhtml;
        }

        public void setEnableKflF2e(boolean state) {
            this.kflF2e = state;
        }

        public void setEnableKflF2f(boolean state) {
            this.kflF2f = state;
        }

        public void setEnableKflMissing(boolean state) {
            this.kflMissing = state;
        }

        public void setEnableKflTestCases(boolean state) {
            this.kflTestCases = state;
        }

        public void setEnableBackups(boolean state) {
            this.doBackups = state;
        }

        public void setBackupLevels(int n) {
            if (n > 0) {
                this.backups = n;
            }
        }

        public boolean isHtmlEnabled() {
            return this.genHtml;
        }

        public boolean isXmlEnabled() {
            return this.genXml;
        }

        public boolean isPlainEnabled() {
            return this.genPlain;
        }

        public boolean isCOFEnabled() {
            return this.genCof;
        }

        public boolean isCOFTestCasesEnabled() {
            return this.genCofTestCases;
        }

        public boolean isConfigSectionEnabled() {
            return this.genConfig;
        }

        public boolean isQuestionLogEnabled() {
            return this.genQl;
        }

        public boolean isEnvEnabled() {
            return this.genEnv;
        }

        public boolean isStdEnabled() {
            return this.genStd;
        }

        public boolean isResultsEnabled() {
            return this.genResults;
        }

        public boolean isKflEnabled() {
            return this.genKfl;
        }

        public boolean isKeywordSummaryEnabled() {
            return this.genKws;
        }

        public boolean isIndexHtmlEnabled() {
            return this.indexHtml;
        }

        public boolean isReportHtmlEnabled() {
            return this.reportHtml;
        }

        public boolean isStateFileEnabled(int status) {
            if (status >= this.stateFiles.length) {
                return false;
            }
            return this.stateFiles[status];
        }

        public boolean isKflTestCasesEnabled() {
            return this.kflTestCases;
        }

        public boolean isKflMissingEnabled() {
            return this.kflMissing;
        }

        public boolean isKflF2eEnabled() {
            return this.kflF2e;
        }

        public boolean isKflF2fEnabled() {
            return this.kflF2f;
        }

        public boolean isBackupsEnabled() {
            return this.doBackups;
        }

        public int getBackupLevel() {
            return this.backups;
        }

        public File[] getInitialFiles() {
            if (this.filter instanceof ParameterFilter) {
                File[] initFiles;
                InitialUrlFilter iuf = ((ParameterFilter)this.filter).getIUrlFilter();
                if (iuf == null) {
                    initFiles = null;
                } else if (iuf.getInitFiles() != null) {
                    initFiles = iuf.getInitFiles();
                } else if (iuf.getInitStrings() != null) {
                    String[] s = iuf.getInitStrings();
                    initFiles = new File[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        initFiles[i] = new File(s[i]);
                    }
                } else {
                    initFiles = null;
                }
                return initFiles;
            }
            if (this.filter instanceof LastRunFilter) {
                return ((LastRunFilter)this.filter).getTestURLs();
            }
            return null;
        }

        public TestFilter getTestFilter() {
            return this.filter;
        }

        public InterviewParameters getInterview() {
            return this.ip;
        }

        private static boolean parseBoolean(String s) {
            if (s == null) {
                return false;
            }
            return s.equalsIgnoreCase("true");
        }
    }

    private class LinkFinder {
        private File index;

        public LinkFinder(File index) {
            this.index = index;
        }

        public Vector getLinks() {
            Vector<String> links = new Vector<String>();
            StringBuilder content = new StringBuilder();
            try {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(this.index)));
                while ((line = r.readLine()) != null) {
                    content.append(line);
                    content.append("\n");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            int i = 0;
            while (i < content.length() - 1) {
                if (content.charAt(i) == '<' && content.charAt(i + 1) == 'a') {
                    StringBuffer link = new StringBuffer();
                    link.append(content.charAt(i));
                    link.append(content.charAt(++i));
                    ++i;
                    boolean end = false;
                    while (!end && i < content.length() - 1) {
                        if (content.charAt(i) == '/' && content.charAt(i + 1) == 'a') {
                            link.append(content.charAt(i));
                            link.append(content.charAt(++i));
                            link.append(content.charAt(++i));
                            ++i;
                            end = true;
                            continue;
                        }
                        link.append(content.charAt(i));
                        ++i;
                    }
                    links.add(link.toString());
                    continue;
                }
                ++i;
            }
            return links;
        }
    }
}

